/*--------------------------------------------------------------------
 * TITLE: Test math
 * AUTHOR: John
 * DATE CREATED: 12/15/2010
 * FILENAME: math_test.c
 * PROJECT: m1/s1
 * DESCRIPTION:
 *    Test math lib for m1/s1 Real Time Operating System
 *
 *  using string lib only
 *
 *  2018-02-09 - update - passed all FP func, except Atan2 not verified yet
 *
 *--------------------------------------------------------------------*/
// #include "../kernel/rtos.h"
#include "math.h"
#include "uartstr.h"

//******************************************************************

void user_interrupt (void)
{
}

void print_hex(unsigned long num)
{
   long i;
   unsigned long j;
   for(i = 28; i >= 0; i -= 4)
   {
      j = (num >> i) & 0xf;
      if(j < 10)
         uart_putch('0' + j);
      else
         uart_putch('a' - 10 + j);
   }
}


//******************************************************************


char *strcpy2(char *s, const char *t)
{
   char *tmp=s;
   while((int)(*s++=*t++)) ;
   return(tmp);
}

void TestMath(long la, long lb, long num)
{
   float sum, sub, div, neg;

   uart_puts("Start MathTest\n");

   sum = (float)la + (float)lb;
   uart_puts(" sum="); print_hex((int)sum);             // good: 0x20b=523

   sub = (float)la - (float)lb;              // 511-12  = 499
   uart_puts("\n sub="); print_hex((int)sub);              // good: 0x1f3=499

   div  = (float)la/(float)lb;
   uart_puts("\n div="); print_hex((int)(div*(float)num)); // good: 0xa657 = 42.583
   
   float pi, pi2, pi_3;
  
   pi = FP_ToFloat(31415026)/FP_ToFloat(10000000); 
   pi_3 = pi/FP_ToFloat(3);
   float pi_31 = pi/3.0;    //not working
   float pi_32 = pi/(float)3.0; //not working
   pi2 = pi*(float)2.0;
   float pi21 = pi*2;
   float pi22 = pi*2.0;                   

   uart_puts("\n pi="); print_hex((int)(pi*(float)num));    //good value is 0xc45
   uart_puts("\n pi_3="); print_hex((int)(pi_3*(float)num)); //good value is 0x417
   uart_puts("\n pi_31="); print_hex((int)(pi_31*(float)num));
   uart_puts("\n pi_32="); print_hex((int)(pi_32*(float)num));
   uart_puts("\n pi2="); print_hex((int)(pi2*(float)num));  //good value is 0x188b
   uart_puts("\n pi21="); print_hex((int)(pi21*(float)num));
   uart_puts("\n pi22="); print_hex((int)(pi22*(float)num));

   float num_10 = FP_ToFloat(10);                    // 10.0
   //float num_10 = 10.0; 
   //or
   //float num_10 = (float)10.0; 
   //above both does not work, to convert a constant to float at compile time does not work, PLEASE NOTE
   float num_3 = FP_ToFloat(3);                      // 3.0
   float num_m3 = FP_ToFloat(-3);                      // -3.0
   float num_1 = FP_ToFloat(1);                      // 1.0
   float num_m1 = FP_ToFloat(-1);                      // -1.0

   neg  = sqrt(num_10);
   uart_puts("\n sqrt="); print_hex((int)(neg*(float)num)); // good   0xc5a = 3162

   neg = cos(num_1);
   uart_puts("\n cos="); print_hex((int)(neg*(float)num));  // good 0x21c
 
   neg  = atan(num_1);                            // atan(1)=pi/4=0.78537
   uart_puts("\n atan="); print_hex((int)(neg*(float)num));  //  good  0x311=785

   neg  = atan(num_m1);                            // atan(-1)=-pi/4=-0.78537
   uart_puts("\n atanm="); print_hex((int)(neg*(float)num));  //  good 0xfffffcef = -0x311=-785

   neg  = atan2(num_3, num_3);                     // atan2(3, 3)=pi/4=0.78537
   uart_puts("\n atan2="); print_hex((int)(neg*(float)num));  //  good  0x311=785
   
   neg  = atan2(num_3, num_m3);                    // atan2(3,-3)=3*pi/4=2.35619
   uart_puts("\n atan2m="); print_hex((int)(neg*(float)num));  //  good  0x934=2356

   neg  = atan2(num_m3, num_3);                    // atan2(3,-3)=-pi/4=-0.78537
   uart_puts("\n atan2m2="); print_hex((int)(neg*(float)num));  //  good  0xfffffcef= -0x311 = -785

   neg  = log(num_10);                            // ln(10)=2.302585
   uart_puts("\n log="); print_hex((int)(neg*(float)num));  //  good 0x8fe = 2302

   neg  = exp(num_3);                             // e^3 = 20.08553
   uart_puts("\n exp="); print_hex((int)(neg*(float)num));  // good 0x4e75 = 20085

   neg  = pow(num_10, num_3);                     // 10^3 = 1000
   uart_puts("\n pow="); print_hex((int)neg);               // good 0x3e7 = 999

   uart_putch('\n');
   uart_puts("End MathTest\n");
}

static const long  la = 511;
static const long  lb = 12;
static const long  num = 1000;

void main()
{
   TestMath(la, lb, num);
}

uint32_t __XTAL_FREQ = 8;
















































































































































































































