/**********************************************************
/**
* @file	Timer.c
*
* This file does a minimal test on the timer counter in M2
* as an example to illustrate how to use the timer in a polled
* mode.
*
* The timer in this example is set to 25.5ms. Once it reaches 
* the timer, the flag of TC1 will be asserted. The main function 
* contains a loop which waits for the flag of TC1 is asserted. 
*
*
* MODIFICATION HISTORY:
*
* Ver   Who		Date      Changes
* ---   ------	--------  --------------------------------
* 1.0	yuchun  02/22/17  First release
*
***********************************************************/

/****************** Include Files *************************/
#include "MCU.h"
#include "str.h"
#include "TIMER.h"
#include "uartstr.h"
#include "CORE.h"

/*********************************************************/
/**
* This function is the user interrupt handler.
*
*
**********************************************************/
void user_interrupt(void){}

/*********************************************************/
/**
* This function is used to print the timer value
*
*
**********************************************************/
void PrintTimer(){
    int cnt;
    cnt = RT_TIMER_ReadCnt(MCU_TIMER0);    // read the TC1 cnt value
    uart_puts(xtoa(cnt));
    uart_puts("\r\n");	
}


/*********************************************************/
/**
* This function is the main function
*
*
**********************************************************/
int main(void) {
    RT_TIMER_SetCLKBase(MCU_TIMER0, TIMER_CLKBASE_SYS);	
    RT_TIMER_Clr(MCU_TIMER0);					// clear irq and cnt value
    RT_TIMER_Set100u(MCU_TIMER0, 255, 0);	// set the timer of 25.5ms, with no interrupt
    		
    while(1) {
        while(RT_TIMER_GetIRQ(MCU_TIMER0)) {
            RT_TIMER_Stop(MCU_TIMER0);			// timer off
            uart_puts("timer: ");		
            PrintTimer();			// print current timer value
            RT_TIMER_Clr(MCU_TIMER0);			// clear irq and cnt value
            RT_TIMER_Set100u(MCU_TIMER0, 255, 0); 	// timer on
        }
    }
    return 0;
}

uint32_t __XTAL_FREQ = 8;




































