/**********************************************************
/**
* @file	pwm.c
*
* This file does a minimal test on the timer counter in M2
* as an example to illustrate how to use the tc module to
* generate pwm ouptut
*
* The frequency of the pwm in this example is set to 5.8khz.
* and with the duty cycle of 15%. 
*
*
* MODIFICATION HISTORY:
*
* Ver   Who		Date      Changes
* ---   ------	--------  --------------------------------
* 1.0	yuchun  07/01/17  First release
*
***********************************************************/

/****************** Include Files *************************/
#include "MCU.h"
#include "str.h"
#include "GPIO.h"
#include "UART.h"
#include "CORE.h"
#include "uartstr.h"
#include "CORE.h"
#include "AFE.h"
#include "EXINT.h"
#include "CCU.h"
#include "TIMER.h"
#include "SPI.h"
#define  TC0  0x1f800100
#define  TC1  0x1f800800
/*********************************************************/
/**
* This function is the user interrupt handler.
*
*
**********************************************************/
void user_interrupt(void){}


/*********************************************************/
/**
* This function is the main function
*
*
**********************************************************/
int main(void) {
	RT_TIMER_PWM_Stop(TC0);
	
	//RT_T0_Clr();					// clear irq and cnt value
	RT_TIMER_PWM_Clr(TC0);
	
	//RT_T0_PWM(1, 38, 0);			// set the timer of 25.5ms, with no interrupt
	RT_TIMER_PWM_Init(TC0,0xa5,0xA5A5,0);
	RT_TIMER_PWM_Start(TC0);  //enable pwm0
		
	return 0;
}






