//################################################################
// TITLE: Mini Boot Loader - m2-sejoy
// AUTHOR: John & Matt
// DATE CREATED: 12/10/2013
// FILENAME: minib.c
// PROJECT: m2-sejoy
// COPYRIGHT: Copyright (C) Camel Microelectronics, Inc.
// DESCRIPTION:
// Rev No.: V1.8
//
//   Mini Boot Loader resides @0        (2kx32 rom)
//
//  06/02/2014 - john - V1.8 - print_sysctl, clean up, and put rev, mode infor 
//  04/27/2014 - john - V1.7 - remove print_gdr in interrupt(); make it release version 
//  03/27/2014 - matt - B1.6 - T3 -> T2, max line of loader increased 
//                             to 32k lines (to fit sejoy)
//  02/26/2014 - john - B1.5 - remove explicit uart print functions
//  01/24/2014 - matt - B1.3 - more dbg msg added for loader part
//                             load file size up to 16k lines (flash size)
//  01/22/2014 - matt - B1.2 - file transfer modification 
//                           - added write loop and read loop for testing
//  12/10/2013 - john - B1.1 - based on m1 minib.c, porting to m2 sejoy
//                             use m2.h
//   
//################################################################

#include "MCU.h"
#include "str.h"
#include "GPIO.h"
#include "UART.h"
#include "CORE.h"
#include "uartstr.h"
#include "CORE.h"
#include "AFE.h"
#include "EXINT.h"
#include "CCU.h"
#include "TIMER.h"
#include "SPI.h"
#include "mod.h"

long cc;
extern long bb;
extern long aa;
long aa = 0;
long bb = 0;
void user_interrupt(void)
{
bb = 100;
}
int main(void)
{
 	int i,  j, size, res;	
	int address, value, count, offset;
	address = 0x1234;
	value = 0x4321;
	count = 0x1111;
	offset = 0x11;
	//MemoryWrite32(0x1f800004, 0x40);
aa = 10;
cc = 1000;
	size = 50000;
	for (  i = 0; i < size; i++)
 	{
		for (j = 0; j < 2; j++) {
 		uart_puts(xtoa(i));
 		uart_puts(" ");
 		uart_puts("hello world ");
		}
   		res = findmod(i, 3);
		if (res == 1) {
			int j = 0x14;
			uart_puts(xtoa(j*i));
			uart_puts(" ");
			uart_puts("helloworld1 ");
		} else if (res == 2) {
			int k = 0x8;
			uart_puts(xtoa(k*i));
			uart_puts(" helloworld2 ");
		} else {
			uart_puts("helloworld3 ");
		}
           value = i*2;
           uart_puts(xtoa(value));
           uart_puts("\n\r");
	} // for

	return 0;
}
