/**********************************************************
/**
* @file	exint.c
*
* This file contains an example to test external interrupt in M2.
*
* INT 0 interrupt is enabled in this example. Once the button INT0
* is pressed, the interrupt will occur.
*
*
*
* MODIFICATION HISTORY:
*
* Ver   Who		Date      Changes
* ---   ------	--------  --------------------------------
* 1.0	yuchun  02/23/17  First release
*
***********************************************************/

/****************** Include Files *************************/
#include "MCU.h"
#include "str.h"
#include "GPIO.h"
#include "UART.h"
#include "CORE.h"
#include "uartstr.h"
#include "CORE.h"
#include "AFE.h"
#include "EXINT.h"
#include "CCU.h"
#include "TIMER.h"
#include "SPI.h"

/*********************************************************/
/**
* This function is the user interrupt handler.
*
* External Interrupt Source Table
*
* ---------------------------------------------------------------
* Num 7 | Num 6 | Num 5 | Num 4 | Num 3 | Num 2 | Num 1 | Num 0 |
* ---------------------------------------------------------------
* rtc_p5| N/A	| INT 5 | INT 4 | INT 3 | INT 2 | INT 1 | INT 0 |
* ---------------------------------------------------------------
*
**********************************************************/
void user_interrupt() {
	uart_puts("h\n");

	int flag = RT_EXINT_Flag();		// check interrupt source
	int keyNum = (flag-1) & 0xf;
	uart_puts("\n");
	switch(keyNum){
		case 0x0:
			uart_puts("INT0 is pressed");
		break;
		case 0x1:
			uart_puts("INT1 is pressed");
		break;
		default:
			uart_puts("Others");
		break;
	}
	uart_puts("\n");
	RT_EXINT_Clr();	  // clear all irq
	//RT_EXINT_Clr(keyNum);			// clear irq 
}

/*********************************************************/
/**
* This function is the main function
*
*
**********************************************************/

int main(void) {
	uart_puts("hello\n");	
	RT_EXINT_Clr();		  // clear all irq
	uart_puts("hi\n");
	//RT_EXINT_Set(0x0, 0);		  // INT0 enable, falling edge trigger
	RT_EXINT_On(0x0,0);  //INT0 enable, falling edge trigger
	uart_puts("hihi\n");
	
		
	while(1) {
		
		uart_puts("Press INT0 to test external interrupt!\n");
				
	}
	
	return 0;
}




