/**********************************************************
/**
* @file	hello.c
*
* This file contains an example to do loop printing
* a string of "Hello!"
*
*
* MODIFICATION HISTORY:
*
* Ver   Who		Date      Changes
* ---   ------	--------  --------------------------------
* 1.0	yuchun  02/22/17  First release
*
***********************************************************/
#include "MCU.h"
#include "str.h"
#include "GPIO.h"
#include "UART.h"
#include "CORE.h"
#include "uartstr.h"
#include "CORE.h"
#include "AFE.h"
#include "EXINT.h"
#include "CCU.h"
#include "TIMER.h"
#include "SPI.h"
#include "INT_CLK.h"
/*********************************************************/
/**
* This function is the user interrupt handler.
*
*
**********************************************************/
void user_interrupt(void){
    uart_puts("in user interrupt\n");
    MemoryWrite32(0x1f800003, 0);
}

/*********************************************************/
/**
* This function is the main function
*
*
**********************************************************/

int main(){
	int s;
	s = 0;
     MemoryWrite32(0x1f800004, 0x2);
	//MemoryOr32(0x1f800700, 0x00000100);
	Calibrate_Internal_Clock(32);  //this call will adjust the MCU main freq to 32Mhz, and uart baudrate to 38400
	MemoryWrite32(0x1f800700, 0x00000001);
	flashWriteEnable();
	flashErase(0x10010000);
	flashWrite(0x10010000, 0x123);
	flashWriteDisable();
	s = MemoryRead(0x10010000);
	
	while(1){
			uart_puts(" 700: ");
                uart_puts(xtoa(MemoryRead32(0x1f800700)));
                uart_puts(" 701: ");
			uart_puts(xtoa(MemoryRead32(0x1f800701)));
                uart_puts(" 702: ");
			uart_puts(xtoa(MemoryRead32(0x1f800702)));
                uart_puts(" 007: ");
			uart_puts(xtoa(MemoryRead32(0x1f800007)));
                uart_puts(" ");
                uart_puts(xtoa(MemoryRead32(0x1f800004)));
			if (s == 0x123) {
				uart_puts(" PASS");
			} else {
				uart_puts(" FAIL");
			}
                uart_puts("\n");
	}
	
}









































