/**********************************************************
/**
* @file	lowpowermode.c
*
* This file contains an example to demo low power operation
* the code does a regular sum of 1 to 100, then does a low power
* mode sum of 1 to 100, by checking the time spend on these 
* steps, one can see during the low power mode, the process is 
* much slower
*
*
* MODIFICATION HISTORY:
*
* Ver   Who		Date      Changes
* ---   ------	--------  --------------------------------
* 1.0	  Weize    06/25/21  First release
*
***********************************************************/
#include "MCU.h"
#include "str.h"
#include "UART.h"
#include "CORE.h"
#include "uartstr.h"

/*********************************************************/
/**
* This function is the main function
*
*
**********************************************************/

void main(){
	int i, sum;
	uart_puts("Start adding 1 to 10000!\n");
	sum = 0;
	for (i = 0; i < 10000; i++) {
		sum += i;
	}
	uart_puts("sum is ");
	uart_puts(xtoa(sum));
	uart_puts("\n");
	uart_puts("Start adding 1 to 10000 in low power mode!\n");
	RT_Enable_LowPower(1);
	sum = 0;
	for (i = 0; i < 10000; i++) {
		sum += i;
	}
	RT_Enable_LowPower(0);
	uart_puts("sum is ");
	uart_puts(xtoa(sum));
	uart_puts("\n");
}









































