/**********************************************************
/**
* @file	Timer.c
*
* This file does a minimal test on the timer counter in M2
* as an example to illustrate how to use the timer in a polled
* mode.
*
* The timer in this example is set to 25.5ms. Once it reaches 
* the timer, the flag of TC1 will be asserted. The main function 
* contains a loop which waits for the flag of TC1 is asserted. 
*
*
* MODIFICATION HISTORY:
*
* Ver   Who		Date      Changes
* ---   ------	--------  --------------------------------
* 1.0	yuchun  02/22/17  First release
*
***********************************************************/

/****************** Include Files *************************/
#include "MCU.h"
#include "str.h"
#include "GPIO.h"
#include "UART.h"
#include "CORE.h"
#include "uartstr.h"
#include "CORE.h"
#include "AFE.h"
#include "EXINT.h"
#include "CCU.h"
#include "TIMER.h"
#include "SPI.h"
#include "INT_CLK.h"

#define  TC0  0x1f800100
#define  TC1  0x1f800800
/*********************************************************/
/**
* This function is the user interrupt handler.
*
*
**********************************************************/
void user_interrupt(void){}

/*********************************************************/
/**
* This function is used to print the timer value
*
*
**********************************************************/
void PrintTimer(){
	int cnt;
	//cnt = RT_T1_ReadCnt();    // read the TC1 cnt value
	cnt = RT_TIMER_ReadCnt(TC0);
	uart_puts(xtoa(cnt));
	uart_puts("\r\n");	
}


/*********************************************************/
/**
* This function is the main function
*
*
**********************************************************/
int main(void) {
	uint32_t pin3, pll, clk_bit, ref_bit, pll_bits, freq, count;
          Calibrate_Internal_Clock(32);
	uart_puts("hello\n");	
	//RT_T1_Clr();					// clear irq and cnt value
	RT_TIMER_Clr(TC0);
	
	
	//RT_T1_Set100u(255,0);			// set the timer of 25.5ms, with no interrupt
	RT_TIMER_Set100u(TC0,255,0);
    pll = RT_SYS_Get_PLL_Freq_khz();
    clk_bit = MCU_REG_READ(MCU_CLK_CTRL, CLK_DIV_Msk, CLK_DIV_Pos);
    ref_bit = MCU_REG_READ(MCU_PLL_CTRL, XTAL_DIV_EN_Msk, XTAL_DIV_EN_Pos);
    pll_bits = MCU_REG_READ(MCU_PLL_CTRL, PLL_REFDIV_Msk, PLL_REFDIV_Pos);
    freq = RT_SYS_Get_CLK_Freq_khz();
    count = (*(MCU_TIMER_CLK_TypeDef *)(TC0+MCU_TIMER_CLK_Pos));
    uart_puts("pll = ");
    uart_puts(xtoa(pll));
    uart_puts(" clk_bit = ");
    uart_puts(xtoa(clk_bit));
    uart_puts(" ref_bit = ");
    uart_puts(xtoa(ref_bit));
    uart_puts(" pll_bits = ");
    uart_puts(xtoa(pll_bits));
    uart_puts(" freq = ");
    uart_puts(xtoa(freq));
    uart_puts(" count = ");
    uart_puts(xtoa(count));
    uart_puts("\n");
	RT_GPIO_EnWriteBit(3, 1);  //enable GPIO3 for output
          pin3 = 0;
          RT_GPIO_WriteBit(3, pin3);	
	while(1) {

		while(RT_TIMER_GetIRQ(TC0)) {

			//RT_TIMER_Stop(TC0);
			//uart_puts("timer: ");		
			//PrintTimer();			// print current timer value
			//RT_T1_Clr();			// clear irq and cnt value
			if (pin3 == 0) {
                                  pin3 = 1;
                              } else {
                                  pin3 = 0;
                              }
                              RT_GPIO_WriteBit(3, pin3);
                              RT_TIMER_Clr(TC0);
			//RT_T1_Set100u(255,0); 	// timer on
			//RT_TIMER_Set100u(TC0,255,0)

		}
	}
		
	return 0;
}






































































































