/**********************************************************
/**
* @file	wakeup.c
*
* This file contains an example to print "hello", 
* then sleep 10 seconds, and print "wakeup"
*
*
* MODIFICATION HISTORY:
*
* Ver   Who		Date      Changes
* ---   ------	--------  --------------------------------
* 1.0	  Weize    06/25/21  First release
*
***********************************************************/
#include "MCU.h"
#include "str.h"
#include "UART.h"
#include "CORE.h"
#include "uartstr.h"
#include "WAK.h"

/*********************************************************/
/**
* This function is the main function
*
*
**********************************************************/

void main(){
	uart_puts("Hello!\n");
	RT_WAKE_SetTime(5, WAKE_CLK_2);
	uart_puts(xtoa(MCU_WAK_CTRL));
	uart_puts("\nEntering Sleep now ...\n");
	RT_WAKE_Start_DeepSleep();
	uart_puts("Failed if reach here from deep sleep!\n");
}









































