//**********************************************************
/**
* @file	io.c
*
* This file contains a example using gdr out and I/O functon.
*
* the output from gdr[7:0] has a pattern of 0101-0101 which can 
* be detected from pin P_SEG[27:20]
*
* GPIO[15] is selected in this example which can be configured 
* either as an input or output based on the application.
*
*
* MODIFICATION HISTORY:
*
* Ver   Who		Date      Changes
* ---   ------	--------  --------------------------------
* 1.0	yuchun  11/12/16  First release
*
***********************************************************/

/****************** Include Files *************************/
#include "MCU.h"
#include "str.h"
#include "GPIO.h"

/*********************************************************/
/**
* This function is the user interrupt handler.
*
*
**********************************************************/
void user_interrupt(void){}

/*********************************************************/
/**
* This function is the main function
*
*
**********************************************************/

int main(void)
{
	int i = 0;
	
	//RT_GDR_Write32(0x55);		// write gdr[7:0] out 0101-0101, 1=high, 0=low
	MCU_REG_WRITE(MCU_CTRL, CTRL_GPIO_EN_Msk, CTRL_GPIO_EN_Pos, 1);
	//RT_IOCTL_Set1(0,1);		// set GPIO[15] as an output
	RT_GPIO_EnWriteBit(0,1);   //set io[0] is output
 	while (1) {
		i++;
		if (i%2) {
			//RT_GPIO0_Write1(0,0); 		// write GPIO[15] 0 to set it low
			RT_GPIO_WriteBit(0,0);   //set io[0] low 
		}
		else {
			//RT_GPIO0_Write1(0,1);
			RT_GPIO_WriteBit(0,1);   //set io[0] high
		}
     }
	
	//puts(xtoa(RT_GPIO0_Read1(6)));
	//puts("\n");
	return 0;
}
