/**********************************************************
/**
* @file	Timer.c
*
* This file does a minimal test on the timer counter in M2
* as an example to illustrate how to use the timer in a polled
* mode.
*
* The timer in this example is set to 25.5ms. Once it reaches 
* the timer, the flag of TC1 will be asserted. The main function 
* contains a loop which waits for the flag of TC1 is asserted. 
*
*
* MODIFICATION HISTORY:
*
* Ver   Who		Date      Changes
* ---   ------	--------  --------------------------------
* 1.0	yuchun  02/22/17  First release
*
***********************************************************/

/****************** Include Files *************************/
#include "MCU.h"
#include "str.h"
#include "GPIO.h"
#include "UART.h"
#include "CORE.h"
#include "uartstr.h"
#include "CORE.h"
#include "AFE.h"
#include "EXINT.h"
#include "CCU.h"
#include "TIMER.h"
#include "SPI.h"

#define  TC0  0x1f800100
#define  TC1  0x1f800800
/*********************************************************/
/**
* This function is the user interrupt handler.
*
*
**********************************************************/
void user_interrupt(void){}

/*********************************************************/
/**
* This function is used to print the timer value
*
*
**********************************************************/
void PrintTimer(){
	int cnt;
	//cnt = RT_T1_ReadCnt();    // read the TC1 cnt value
	cnt = RT_TIMER_ReadCnt(TC0);
	uart_puts(xtoa(cnt));
	uart_puts("\r\n");	
}


/*********************************************************/
/**
* This function is the main function
*
*
**********************************************************/
int main(void) {
	
	uart_puts("hello\n");	
	//RT_T1_Clr();					// clear irq and cnt value
	RT_TIMER_Clr(TC0);
	
	
	//RT_T1_Set100u(255,0);			// set the timer of 25.5ms, with no interrupt
	RT_TIMER_Set100u(TC0,255,0)
		
	while(1) {

		while(RT_TIMER_GetIRQ(TC0)) {

			//RT_T1_Stop();			// timer off
			RT_TIMER_Stop(TC0);
			uart_puts("timer: ");		
			PrintTimer();			// print current timer value
			//RT_T1_Clr();			// clear irq and cnt value
			RT_TIMER_Clr(TC0);
			//RT_T1_Set100u(255,0); 	// timer on
			RT_TIMER_Set100u(TC0,255,0)

		}
	}
		
	return 0;
}






