/**********************************************************
/**
* @file	TimerInterrupt.c
*
* This file contains an example using the timer counter in interrupt
* mode.
*
* The timer in this example is set to 25.5ms. The main function contains
* a loop printing function and once the timer reaches the time, the 
* interrupt will occur.
*
*
* MODIFICATION HISTORY:
*
* Ver   Who		Date      Changes
* ---   ------	--------  --------------------------------
* 1.0	yuchun  02/22/17  First release
*
***********************************************************/

/****************** Include Files *************************/
#include "MCU.h"
#include "CORE.h"
#include "str.h"
#include "uartstr.h"
#include "TIMER.h"

/*********************************************************/
/**
* This function is used to print the timer value
*
*
**********************************************************/
void PrintTimer(){
	int cnt;
	cnt = RT_TIMER_ReadCnt(MCU_TIMER0);    // read the TC1 cnt value
	uart_puts(xtoa(cnt));
	uart_puts("\r\n");	
}

/*********************************************************/
/**
* This function is the user interrupt handler.
*
*
**********************************************************/
void user_interrupt(void){
	
	RT_TIMER_Stop(MCU_TIMER0);			// timer off
	uart_puts("\n interrupt --- timer: ");	
	PrintTimer();			// print current timer value 
	RT_TIMER_Clr(MCU_TIMER0);			// clear irq and cnt value			
	RT_TIMER_Set100u(MCU_TIMER0, 255, 1)	// timer on， interrupt enable
}

void TC0_IRQHandler(void) {
	RT_TIMER_Stop(MCU_TIMER0);			// timer off
	uart_puts("\n interrupt handler --- timer: ");	
	PrintTimer();			// print current timer value 
	RT_TIMER_Clr(MCU_TIMER0);			// clear irq and cnt value			
	RT_TIMER_Set100u(MCU_TIMER0, 255, 1)	// timer on， interrupt enable
}

/*********************************************************/
/**
* This function is the main function
*
*
**********************************************************/
int main(void) {
        //RT_SYS_EnInt();
	MCU_REG_WRITE(MCU_CTRL, CTRL_IRQ_EN_Msk, CTRL_IRQ_EN_Pos, 1);
	
	RT_TIMER_Clr(MCU_TIMER0);				// clear irq and cnt value
	
	RT_TIMER_Set100u(MCU_TIMER0, 255,1);		// set the timer of 25.5ms, interrupt enabled
	
		
	while(1) {
		
		uart_puts("test!\n");

	}
		
	return 0;
}






