
#include "MCU.h"
#include "str.h"
#include "GPIO.h"
#include "UART.h"
#include "CORE.h"
#include "uartstr.h"
#include "CORE.h"
#include "AFE.h"
#include "EXINT.h"
#include "CCU.h"
#include "TIMER.h"
#include "SPI.h"
#include "mod.h"
#include "submod.h"
#include "internalClockAdjust.h"

typedef struct
{
    uint16_t a;
    uint16_t b;
} stru_gpio;
stru_gpio gpioConfig[] = 
{
    {1, 10},
    {2, 11},
    {3, 12},
    {4, 13},
    {5, 14},
    {6, 15},
    {7, 16},
    {8, 17},
    {11, 110},
    {12, 111},
    {13, 112},
    {14, 113},
    {15, 114},
    {16, 115},
    {17, 116},
    {18, 117}
};

long gc;
int gb;
extern int ga;
extern long dd;
int ga = 0;
char gd;
short ge;
int gf;
int gg;
int gh;
int gi;
int gj;
int gk;
int gl;
int * gpointer = (int *)0x1002000;
int gas[2];
const int gx = 100;

static long sc;
static int sb;
static char sd;
static int sas[10];

extern t_st3 gstd;
static t_st3 ssta[16];
/*
void user_interrupt(void)
{
    dd = dd + 1;
}
*/

void test_global(void)
{
    static int sfa;
    ga = 321;
    gb = 3;
    gc = 2;
    gd = 'd';
    ge = 0x100;
    gas[0] = 0;
    gas[1] = 1;
    sfa = ga;
    gb = sfa++;
}

void test_static(void)
{
    static int sfa;
    sb = 10;
    sc = 100;
    sd = 'a';
    for (int i = 0; i < 10; i++) {
        sas[i] = i;
    }
    sfa = sb;
    sfa++;
}

void test_struct(void)
{
    gstd.start = 3;
    gstd.start0 = 5;
    gstd.pwr = 'a';
    gstd.ends[0] = 'b';
    gstd.ends[1] = 'a';
    for (int i = 0; i <16; i++) {
        ssta[i].start = i;
        ssta[i].start0 = 2+i;
        ssta[i].pwr = 'a'+i;
        ssta[i].ends[0] = 'b'+i;
        ssta[i].ends[1] = 'c'+i;
    }
}

void main(void)
{
    int i,  j, size, res;
    char cs0, cs1;	
    int address, value, count, offset, addr;
    int vas[4];

    //the chip clk_375 measure freq is 522kHz, so the pll freq is 522kHz * 256 = 133.6Mhz,
    //the default PLL to osc ratio is 12, so the osc freq is 133.6Mhz/12=11.1Mhz
    //this is the osc freq of the osc adjusted by -8, it is the highest freq 
    // of the internal osc can be adjusted to. to get MCU clock at 32Mhz, we would like to have PLL freq at 128Mhz, with a PLL2MCU ratio 4, 
    // the MCU freq can be at 32Mhz
    // so we will need to lower osc freq by -5% to get PLL freq at 128Mhz, so oscAdj will be -7, since the default is -8
    // since the pllAdj will be kept at default which is 0 and correspond to PLL to osc ratio 12
    // and clkAdj will be set to 4
    //adjustMCUClock(0, 12, 4);

    address = 0x1234;
    value = 0x4321;
    count = 0x1111;
    offset = 0x11;
    vas[0] = 1;
    vas[1] = 2; 
    vas[2] = 5;
    vas[3] = 7;
    MemoryWrite32(0x1f800004, 0x2);
    ga = 1;
    gb = 100;
    gc = 10;
    gd = 'a';
    ge = 0x20;
    gf = 2;
    gg = 3;
    gh = 4;
    gi = 5; 
    gj = 6;
    gk = 7;
    gl = 8;
    cs0 = 'a';
    cs1 = 'b';
    
    gstd.start = 3;
    gstd.start0 = 5;
    gstd.s0 = 1000;
    gstd.pwr = 90;
    gstd.s1 = 0xf0000;
    gstd.ends[0] = 80;
    gstd.ends[1] = 70;
    gstd.s2 = 10000;
    //
    uart_puts("start :\n");
    uart_puts(xtoa(vas[0]));
    uart_puts(xtoa(vas[1]));
    uart_puts(xtoa(vas[2]));
    uart_puts(xtoa(vas[3]));
    
    uart_puts(xtoa((int)vas));
    uart_puts("\n");
    uart_puts(xtoa(gc));
    uart_puts(" gc ");
    uart_puts(xtoa((int)&gc));
    uart_puts(" ");
    uart_puts(xtoa(gf));
    uart_puts(" gf ");
    uart_puts(xtoa((int)&gf));
    uart_puts(" ");
    uart_puts(xtoa(gg));
    uart_puts(" gg ");
    uart_puts(xtoa((int)&gg));
    uart_puts("\n");
    uart_puts(xtoa(gh));
    uart_puts(" gh ");
    uart_puts(xtoa((int)&gh));
    
    uart_puts(" ");
    uart_puts(xtoa(gi));
    uart_puts(" gi ");
    uart_puts(xtoa((int)&gi));
    uart_puts(" ");
    uart_puts(xtoa(gj));
    uart_puts(" gj ");
    uart_puts(xtoa((int)&gj));
    uart_puts(" ");
    uart_puts(xtoa(gk));
    uart_puts(" gk ");
    uart_puts(xtoa((int)&gk));
    uart_puts("\n");
    uart_puts(xtoa(gstd.pwr));
    uart_puts(" pwr ");
    uart_puts(xtoa((int)&gstd.pwr));
    uart_puts("\nvariable adress: ");
    uart_puts(" s0 ");
    uart_puts(xtoa((int)&gstd.s0));
    uart_puts(" ends[0] ");
    uart_puts(xtoa((int)&gstd.ends[0]));
    uart_puts(" ends[1] ");
    uart_puts(xtoa((int)&gstd.ends[1]));
    uart_puts(" s2 ");
    uart_puts(xtoa((int)&gstd.s2));
    uart_puts("\ncs0 ");
    uart_puts(xtoa((int)&cs0));
    uart_puts(" cs1 ");
    uart_puts(xtoa((int)&cs1));
    uart_puts(" address ");
    uart_puts(xtoa((int)&address));
    uart_puts("\n");
    
    size = 50000;
    
    uart_puts(" ");
    uart_puts(xtoa(gk));
    uart_puts(" gk ");
    uart_puts(xtoa((int)&gk));
    uart_puts(" ");
    uart_puts(xtoa(gb));
    uart_puts(" gb ");
    uart_puts(xtoa((int)&gb));
    
    test_global();
    test_static();
    test_struct();
    
    ga = 321;
    gb = 3;
    gc = 2;
    gd = 'd';
    ge = 0x100;
    gas[0] = 0;
    gas[1] = 1;
    for ( i = 0; i < 16; i++) {
        uart_puts("\nssta:\n");
        uart_puts(xtoa(ssta[i].start));
        uart_puts(" ");
        uart_puts(xtoa(ssta[i].start0));
        uart_puts(" ");
        uart_puts(xtoa(ssta[i].s0));
        uart_puts(" ");
        uart_puts(xtoa(ssta[i].pwr));
        uart_puts(" ");
        uart_puts(xtoa(ssta[i].s1));
        uart_puts(" ");
        uart_puts(xtoa(ssta[i].ends[0]));
        uart_puts(" ");
        uart_puts(xtoa(ssta[i].ends[1]));
        uart_puts(" ");
    }
    uart_puts("\ngpioconfig address: ");
    uart_puts(xtoa((uint32_t)gpioConfig));
    for ( i = 0; i < 16; i++) {
        uart_puts("\ngpioconfig:\n");
        uart_puts(xtoa(gpioConfig[i].a));
        uart_puts(" ");
        uart_puts(xtoa(gpioConfig[i].b));
    }
    for (  i = 0; i < size; i++)
    {
        for (j = 0; j < 2; j++) {
            uart_puts(xtoa(i));
            uart_puts(" ");
            uart_puts("hello world\"{to user}\", done\n");
            
            ga = j;
            gb = j;
        }
        res = findmod(i, 3);
        if (res == 1) {
            int j = 0x14;
            gi = j*2;
            gj = j;
            
            uart_puts(xtoa(j*i));
            uart_puts(" ");
            uart_puts("helloworld1 \n");
            
        } else if (res == 2) {
            int k = 0x8;
            gi = k;
            gj = k*10;
            
            uart_puts(xtoa(k*i));
            uart_puts(" helloworld2 \n");
            
        } else {
            uart_puts("helloworld3 ");
        }
        value = i*2;
        uart_puts(xtoa(value));
        uart_puts("\n\r");
    } // for
    

    return;
}








































































































































































































































































