/**********************************************************
/**
* @file	io.c
*
* This file contains a example using gdr out and I/O functon.
*
* the output from gdr[7:0] has a pattern of 0101-0101 which can 
* be detected from pin P_SEG[27:20]
*
* GPIO[15] is selected in this example which can be configured 
* either as an input or output based on the application.
*
*
* MODIFICATION HISTORY:
*
* Ver   Who		Date      Changes
* ---   ------	--------  --------------------------------
* 1.0	yuchun  11/12/16  First release
*
***********************************************************/

/****************** Include Files *************************/
#include "str.h"
#include "mcu.h"
#include "MCUIO.h"

/*********************************************************/
/**
* This function is the user interrupt handler.
*
*
**********************************************************/
void user_interrupt(void){}

/*********************************************************/
/**
* This function is the main function
*
*
**********************************************************/

int main(void)
{
	int i = 0;
	
	//RT_GDR_Write32(0x55);		// write gdr[7:0] out 0101-0101, 1=high, 0=low
	
	RT_IOCTL_Set1(0,1);		// set GPIO[15] as an output
 	while (1) {
		i++;
		if (i%2) {
			RT_GPIO_Write1(0,0); 		// write GPIO[15] 0 to set it low
		}
		else {
			RT_GPIO_Write1(0,1);
		}
     }
	
	//puts(xtoa(RT_GPIO_Read1(6)));
	//puts("\n");
	return 1;
}
