/**********************************************************
/**
* @file	wdt.c
*
* This file contains a example using the watch dog timer
*
*
* MODIFICATION HISTORY:
*
* Ver   Who		Date      Changes
* ---   ------	--------  --------------------------------
* 1.0	yuchun  11/07/16  First release
*
***********************************************************/

/****************** Include Files *************************/
#include "str.h"
#include "mcu.h"
#include "WDT.h"

/*********************************************************/
/**
* This function is the user interrupt handler.
*
*
**********************************************************/
void user_interrupt(void)
{}

/*********************************************************/
/**
* This function is the used to reset watch dog timer counter
* before expired.
*
*
**********************************************************/

void KickingDog(){
	
	int value = RT_WDT_ReadCnt();
	value = (value & 0x00000040) >> 6;
	if(value){
		RT_WDT_Clr();
		puts("kicking the dog\n");
		RT_WDT_Clr();		
		value = RT_WDT_ReadCnt();
	}
}


/*********************************************************/
/**
* This function is the main function 
*
**********************************************************/

int main(void)
{
	int i;
	
	puts("start");
	puts("\n");
	
	RT_WDT_Clr();
	RT_WDT_Set(8, 1, 0);		// wdt set to 1s reset
	
	puts("end");
	puts("\n");
	
	while(1) {
		
		puts("test watchdog timer!\n");
		
		KickingDog();
	
	}
	return 1;
}

