/**********************************************************
/**
* @file	Timer.c
*
* This file does a minimal test on the timer counter in M2
* as an example to illustrate how to use the timer in a polled
* mode.
*
* The timer in this example is set to 25.5ms. Once it reaches 
* the timer, the flag of TC1 will be asserted. The main function 
* contains a loop which waits for the flag of TC1 is asserted. 
*
*
* MODIFICATION HISTORY:
*
* Ver   Who		Date      Changes
* ---   ------	--------  --------------------------------
* 1.0	yuchun  02/22/17  First release
*
***********************************************************/

/****************** Include Files *************************/
#include "str.h"
#include "mcu.h"
#include "TC1.h"

/*********************************************************/
/**
* This function is the user interrupt handler.
*
*
**********************************************************/
void user_interrupt(void){}

/*********************************************************/
/**
* This function is used to print the timer value
*
*
**********************************************************/
void PrintTimer(){
	int cnt;
	cnt = RT_T1_ReadCnt();    // read the TC1 cnt value
	puts(xtoa(cnt));
	puts("\r\n");	
}


/*********************************************************/
/**
* This function is the main function
*
*
**********************************************************/
int main(void) {
	
	RT_T1_Clr();					// clear irq and cnt value
	
	RT_T1_Set100u(255,0);			// set the timer of 25.5ms, with no interrupt
	
		
	while(1) {

		while(RT_T1_Flag()) {

			RT_T1_Stop();			// timer off
			puts("timer: ");		
			PrintTimer();			// print current timer value
			RT_T1_Clr();			// clear irq and cnt value
			RT_T1_Set100u(255,0); 	// timer on

		}
	}
		
	return 0;
}






