/**********************************************************
/**
* @file	TimerInterrupt.c
*
* This file contains an example using the timer counter in interrupt
* mode.
*
* The timer in this example is set to 25.5ms. The main function contains
* a loop printing function and once the timer reaches the time, the 
* interrupt will occur.
*
*
* MODIFICATION HISTORY:
*
* Ver   Who		Date      Changes
* ---   ------	--------  --------------------------------
* 1.0	yuchun  02/22/17  First release
*
***********************************************************/

/****************** Include Files *************************/
#include "str.h"
#include "mcu.h"
#include "TC1.h"

/*********************************************************/
/**
* This function is used to print the timer value
*
*
**********************************************************/
void PrintTimer(){
	int cnt;
	cnt = RT_T1_ReadCnt();    // read the TC1 cnt value
	puts(xtoa(cnt));
	puts("\r\n");	
}

/*********************************************************/
/**
* This function is the user interrupt handler.
*
*
**********************************************************/
void user_interrupt(void){
	
	RT_T1_Stop();			// timer off
	puts("\n interrupt --- timer: ");	
	PrintTimer();			// print current timer value 
	RT_T1_Clr();			// clear irq and cnt value			
	RT_T1_Set100u(255, 1)	// timer on， interrupt enable
}

/*********************************************************/
/**
* This function is the main function
*
*
**********************************************************/
int main(void) {
        RT_SYS_EnInt();
	
	RT_T1_Clr();				// clear irq and cnt value
	
	RT_T1_Set100u(255,1);		// set the timer of 25.5ms, interrupt enabled
	
		
	while(1) {
		
		puts("test!\n");

	}
		
	return 0;
}






