/**********************************************************
/**
* @file	v2p.c
*
* This file contains an example to access V2P module in M2.
*
* OPO:	channel	--> channel 1	
*		gain	--> 2
*		operation mode --> differetial
*		feedback --> both side
*
* V2P:	on
*		
* TC0:	pwm --> 46hz, duty cycle=1:10
*		pwmm --> enable
*		
*
* MODIFICATION HISTORY:
*
* Ver   Who		Date      Changes
* ---   ------	--------  --------------------------------
* 1.0	yuchun  02/23/17  First release
*
***********************************************************/
#include "mcu.h"
#include "str.h"
#include "AFE.h"
#include "TC0.h"

/*********************************************************/
/**
* This function is the user interrupt handler.
*
*
**********************************************************/
void user_interrupt() {}


/*********************************************************/
/**
* This function is the main function 
*
**********************************************************/
void main() {
	
	RT_T0_Clr();					// clear TC0 irq flag and cnt value
	RT_T0_PWM(0xff, 0x1b, 0);		// TC0 pwm, clk=0xff, ref=0x1b  
	RT_T0_PulseWidth(1, 0);			// TC0 pwmm enable
	
	RT_OPO_SetEn(1);				// set opo enable
	RT_OPO_SetCh(0, 1 , 0, 0);		// select channel 1
	RT_OPO_SetAmp(0, 0, 7, 7); 		// ngain = pgain = 2	
	//RT_OPO_SetFilter(1)				// bypass
	RT_OPO_SetAmpMode(0);			// feedback at both side
	
	RT_V2P_SetMode(1);				// v2p on
	RT_V2P_SetV2PRes(0);			
	

	while(1) {
					
		puts("channal1: ");
		int result = RT_V2P_Read();
		//result = result & 0xffff;
		puts(xtoa(result));
		puts("\n");
	}

}