//################################################################
// TITLE: Mini Boot Loader - m2-sejoy
// AUTHOR: John & Matt
// DATE CREATED: 12/10/2013
// FILENAME: minib.c
// PROJECT: m2-sejoy
// COPYRIGHT: Copyright (C) Camel Microelectronics, Inc.
// DESCRIPTION:
// Rev No.: V1.8
//
//   Mini Boot Loader resides @0        (2kx32 rom)
//
//  06/02/2014 - john - V1.8 - print_sysctl, clean up, and put rev, mode infor 
//  04/27/2014 - john - V1.7 - remove print_gdr in interrupt(); make it release version 
//  03/27/2014 - matt - B1.6 - T3 -> T2, max line of loader increased 
//                             to 32k lines (to fit sejoy)
//  02/26/2014 - john - B1.5 - remove explicit uart print functions
//  01/24/2014 - matt - B1.3 - more dbg msg added for loader part
//                             load file size up to 16k lines (flash size)
//  01/22/2014 - matt - B1.2 - file transfer modification 
//                           - added write loop and read loop for testing
//  12/10/2013 - john - B1.1 - based on m1 minib.c, porting to m2 sejoy
//                             use m2.h
//   
//################################################################

#include "str.h"
#include "mcu.h"
#include "TC0.h"
#include "MCUIO.h"


#define SYS_GPIO1_REG       0x1f800706
#define T0_CLRIRQ_REG     0x1f800103  


static const unsigned long val[6] = {6, 2, 3, 1, 5, 4};
static int index;


void user_interrupt()
{
	unsigned long irq = MemoryRead32(SYS_IRQ_REG);
	if (irq & 0x2) { //TC0 interrupt
		index++;
		if (index == 6)
			index = 0;
		RT_IO_Write16(val[index]);
		RT_T0_Clr();
//puts(xtoa(index));
//puts("\r");
	}
}


void print_menu()
{
	puts("\r\nenter speed > ");
}


int main(void)
{
	char sp;
	unsigned long speed;
	unsigned long target_speed = 0;
	int tick_num = 0;

	sys_init();
	MemoryWrite32(0x1f800300, 0);
	MemoryWrite32(0x1f800d04, 0x8);
	RT_IO_Set16(7);
	MemoryWrite32(SYS_CTL0_REG, 0x1); //use GPIO to read hall a,b,c, need to do uart_sync to set the correct uart osc freq since the external pin setting no longer work when GPIO is used

	puts("Hello From MCU!\r\n");

	print_menu();
	target_speed = getnum();
	tick_num = 100000/target_speed; // 60 degree travel time in 100us
	
	print_menu();
     	RT_T0_SetTimer(100, tick_num, 1); 
	index = 0;

	for (;;) {
		if (kbhit()) {
			sp = getch();
			if (sp == '\n' || sp == '\r' || sp == ' ') {
				target_speed = speed;
				tick_num = 100000/target_speed;
				print_menu();
				RT_T0_SetTimer(100, tick_num, 1);
				speed = 0;
				index = 0;
			} else {
				if('0' <= sp && sp <= '9')
         					sp -= '0';
      				else if('A' <= sp && sp <= 'Z')
         					sp = sp - 'A' + 10;
      				else if('a' <= sp && sp <= 'z')
         					sp = sp - 'a' + 10;
      				else if(sp == 8)  // ^H  or \b  backspace  ???
            					speed >>= 4;
              				speed = (speed << 4) + sp;
			}
		}

	}

 	return 0;
}	   
