//################################################################
// TITLE: Mini Boot Loader - m2-sejoy
// AUTHOR: John & Matt
// DATE CREATED: 12/10/2013
// FILENAME: minib.c
// PROJECT: m2-sejoy
// COPYRIGHT: Copyright (C) Camel Microelectronics, Inc.
// DESCRIPTION:
// Rev No.: V1.8
//
//   Mini Boot Loader resides @0        (2kx32 rom)
//
//  06/02/2014 - john - V1.8 - print_sysctl, clean up, and put rev, mode infor 
//  04/27/2014 - john - V1.7 - remove print_gdr in interrupt(); make it release version 
//  03/27/2014 - matt - B1.6 - T3 -> T2, max line of loader increased 
//                             to 32k lines (to fit sejoy)
//  02/26/2014 - john - B1.5 - remove explicit uart print functions
//  01/24/2014 - matt - B1.3 - more dbg msg added for loader part
//                             load file size up to 16k lines (flash size)
//  01/22/2014 - matt - B1.2 - file transfer modification 
//                           - added write loop and read loop for testing
//  12/10/2013 - john - B1.1 - based on m1 minib.c, porting to m2 sejoy
//                             use m2.h
//   
//################################################################

#include "str.h"
#include "mcu.h"
#include "TC0.h"
#include "MCUIO.h"

#define EV_PWM_CTL0_REG     0x1f800400
#define EV_PWM_CLRIRQ_REG   0x1f800403
#define EV_PWM_MODULA_REG   0x1f800404
#define EV_PWM_CONF_REG     0x1f800405
#define EV_PWM_REF0_REG     0x1f800408
#define EV_PWM_REF1_REG     0x1f800409
#define EV_PWM_REF2_REG     0x1f80040a
#define EV_PWM_REF3_REG     0x1f80040b
#define EV_PWM_REF4_REG     0x1f80040c
#define EV_PWM_REF5_REG     0x1f80040d
#define EV_PWM_DT10_REG     0x1f80040e
#define SAR_CTL_REG          0x1f800607
#define SYS_GPIO1_REG       0x1f800706
#define A_CMP_CTL_REG       0x1f800606
#define A_CLR_REG           0x1f800603
#define T0_CLRIRQ_REG     0x1f800103  
#define SZ 100

#define MODULA              0x100//0xe6
#define TICK_TIME           10 //10us
#define ANGLE_NUM           90 //angle resolution is 1 degree
#define MIN_IN_USEC         10000000  //60000000/6, 2 of the 6 is counting for the hi/lo value change of the hall sensor, 3 of the 6 is counting for the 3 hall sensors
#define SENSE_STEP    8

static const unsigned long sintable[91] = {
0x4, 0x8, 0xd, 0x11, 0x16, 0x1a, 0x1f, 0x23, 0x28, 0x2c, 
0x30, 0x35, 0x39, 0x3d, 0x42, 0x46, 0x4a, 0x4f, 0x53, 0x57, 
0x5b, 0x5f, 0x64, 0x68, 0x6c, 0x70, 0x74, 0x78, 0x7c, 0x7f, 
0x83, 0x87, 0x8b, 0x8f, 0x92, 0x96, 0x9a, 0x9d, 0xa1, 0xa4, 
0xa7, 0xab, 0xae, 0xb1, 0xb5, 0xb8, 0xbb, 0xbe, 0xc1, 0xc4, 
0xc6, 0xc9, 0xcc, 0xcf, 0xd1, 0xd4, 0xd6, 0xd9, 0xdb, 0xdd, 
0xdf, 0xe2, 0xe4, 0xe6, 0xe8, 0xe9, 0xeb, 0xed, 0xee, 0xf0, 
0xf2, 0xf3, 0xf4, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 
0xfc, 0xfd, 0xfe, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff 
};
static const unsigned long max_speed_shift = 13; //correspond to 8192
static unsigned long target_speed;
static int target_duty;
static unsigned long actual_speed;
static int tick_num;
static int total_tick_num;
static int pwm_duty_calc_done;
static long iVal;
static long pre_err;
static unsigned long duty;
static unsigned long uduty;
static unsigned long vduty;
static unsigned long wduty;
//static unsigned long max_duty;
static unsigned long hall;
static unsigned long prev_hall;
static int pole_num;
static unsigned long speed_times_tick;
static int iii;
static int iiii;
static int id[SZ];
static int aspeed[SZ];
static int atick[SZ];
static int aduty[SZ];
static int at[SZ];
static int aa[SZ];
static int ae[SZ];
static int ap[SZ];
static int ai[SZ];
static int ad[SZ];
static int halls[SZ];
static int ivals[SZ];
static int amps[SZ];
static int prev_avgamp = 0;
static int prev_avgamp2 = 0;
static int sentype = -1; //-1 for find kd sensitivity, -2 for find kp sensitivity, 1 for adjust kd based on the kd sensitivity, 2 for adjust kp based on kp sensitivity
static int kd;
static int kp;
static int ki;
static int target_err;
static int sense_step;
static int sense_thresh;


typedef void (*FuncPtr)(void);
void update_pwm_duty();


void user_interrupt()
{
}

void set_ev_pwm_ref(unsigned long ref1,  unsigned long ref3,  unsigned long ref5)
{
	MemoryWrite32(EV_PWM_REF5_REG, ref5);
	MemoryWrite32(EV_PWM_REF3_REG, ref3);
	MemoryWrite32(EV_PWM_REF1_REG, ref1);
}

void print_menu()
{
	puts("\r\nenter speed > ");
}

void update_pwm_duty()
{
	set_ev_pwm_ref(uduty, vduty, wduty);
}

void ev_init()
{
	MemoryWrite32(EV_PWM_CLRIRQ_REG, 0);  //reset all EV_PWM_REFx_REG to 0
	MemoryWrite32(EV_PWM_CTL0_REG, 0x121); //every two period change EV_PWM_REFx_REG
	MemoryWrite32(EV_PWM_MODULA_REG, MODULA); //set PWM period
	MemoryWrite32(EV_PWM_CONF_REG, 0x000);  //edge align mode,  PWMs are dependent
	MemoryWrite32(EV_PWM_DT10_REG, 0x101); //set deadtime to 1 on each side
	MemoryWrite32(SYS_CTL0_REG, 0x8); //use GPIO to read hall a,b,c, need to do uart_sync to set the correct uart osc freq since the external pin setting no longer work when GPIO is used
	MemoryWrite32(T0_CTL0_REG, 0);
	MemoryWrite32(SAR_CTL_REG, 3);
	RT_IO_Set16(0);
}

void calc_pid()
{
	long error, P_term, I_term, D_term;
	//int kp = 31; //63;
	//int ki = 5;
	//int kd = 15; //40;
	int shift_num = 10;
	error = target_speed - actual_speed;
	P_term = (kp * error)>>shift_num;
	iVal += error;
	I_term = (ki *( iVal>>shift_num));
	D_term = (kd *(pre_err - error))>>shift_num;
	pre_err = error;
	target_duty = target_duty + (P_term + I_term + D_term);
if (iii < SZ)
aduty[iii] = target_duty;
if (target_duty > MODULA)
	target_duty = MODULA;
else
if (target_duty <= 0x20)
	target_duty = 0x20;
if (iii < SZ) {
//aduty[iii] = target_duty;
at[iii] = target_speed;
aa[iii] = actual_speed;
ae[iii] = error;
ai[iii] = I_term;
ap[iii] = P_term;
ad[iii] = D_term;
ivals[iii] = iVal;
}
if (iii == (SZ-1)) {//adjust the parameters to get better fitting
   int i, maxid, minid, index;
   int maxval, minval, avgamp;
   int amps[SZ];
   maxval = 0xffffffff; 
   minval = 0x1fffffff;
   index = 0;
   avgamp =0;
//
   for (i = 0; i < SZ; i++) {
	if (ae[i] > maxval)
		maxval = ae[i];
	if (ae[i] < minval)
		minval = ae[i];
   }
/*
   for (i = 1; i < (SZ-1); i++) {
   	if ((ae[i] < ae[i+1]) && (ae[i] < ae[i-1])) { //local min
		minval = ae[i];
		if (maxval != 0xffffffff) { //has nearby max
			amps[index] = maxval - minval;
			avgamp = avgamp + amps[index];
			index++;
		}
	} else if ((ae[i] > ae[i+1]) && (ae[i] > ae[i-1])) { //local max
		maxval = ae[i];
		if (minval != 0x1fffffff) {// has nearby min
			amps[index] = maxval - minval;
			avgamp = avgamp + amps[index];
			index++;
		}
	}
  }
*/
   if (index >= 0) {
	int avgerr;
	//avgamp = avgamp/index;
	avgamp = maxval - minval;
//puts("\r");
//puts(xtoa(avgamp));
	amps[iiii] = avgamp;
/*
puts("\r");
if (iiii > 0)
puts(xtoa(amps[iiii-1]));
*/
	iiii++;
	if (iiii == SZ)
		iiii = 0;
	if (avgamp < prev_avgamp)
		avgerr = prev_avgamp - avgamp;
	else
		avgerr = avgamp - prev_avgamp;
	if ((avgerr <= (avgamp>>5)) || (avgerr < 0x8)) {
	if (prev_avgamp2 == 0)
		prev_avgamp2 = avgamp;
	else {
  	if (avgamp > target_err) { //adjust PID to lower the oscillation
//puts("\r");
//puts(xtoa(avgerr));
//puts("  ");
//puts(xtoa(avgamp));
/*puts("  ");
puts(xtoa(prev_avgamp2));
puts("  ");
puts(xtoa(aduty[iii]));*/
		if (sentype == 1) { //kd sensitivity is done
			int sensitivity = avgamp - prev_avgamp2;
			if (sensitivity > sense_thresh)  //diverge, worst than previous step, go back to previous step
				sensitivity = sense_step;
			else if (sensitivity < -sense_thresh) //converge
				sensitivity = -sense_step;
			else
				sensitivity = 0;
//puts(" kd ");
//puts(xtoa(kd));
			//kd = kd - avgamp/sensitivity;
			kd = kd - sensitivity;
//puts("->");
//puts(xtoa(kd));
			if (sensitivity == 0) {
				if ((sense_step>>1) >= 2) {
					sense_step = (sense_step>>1);
					sentype = -1;
				} else {
					sense_step = SENSE_STEP;
					sentype = -2;
				}
			} else
				sentype = -1;
		} else if (sentype == 2) { //kp sensitivity is done
			int sensitivity = avgamp - prev_avgamp2;
			if (sensitivity > sense_thresh)  //diverge, worse then previous step, go back to previous step
				sensitivity = sense_step;
			else if (sensitivity < -sense_thresh) //converge
				sensitivity = -sense_step;
			else
				sensitivity = 0;
//puts(" kp ");
//puts(xtoa(kp));
			//kp = kp - avgamp/sensitivity;
			kp = kp - sensitivity;
//puts("->");
//puts(xtoa(kp));
			if (sensitivity == 0) {
				if ((sense_step>>1) >= 2) {
					sense_step = (sense_step>>1);
					sentype = -2;
				} else {
					sense_step = SENSE_STEP;
					sentype = -1;
				}
			} else
				sentype = -2;
		} else if (sentype == -1)  { //do kd sensitivity
//puts(" kd ");
			kd = kd + sense_step;
			sentype = 1;
		} else if (sentype == -2) { //do kp sensitivity
//puts(" kp ");
			kp = kp + sense_step;
			sentype = 2;
		}
		prev_avgamp2 = avgamp;
	} else 
		sentype = -1; //set to do kd adj first when avgamp is out of the bound
	}
	}
	prev_avgamp = avgamp;
   }


   }
}

void debug_dump()
{
int j;
puts("\rcurrent index: ");
puts(xtoa(iii));
for (j = 0; j < SZ; j++) {
puts("\r");
puts(xtoa(id[j]));
puts(" ");
puts(xtoa(halls[j]));
puts(" ");
puts(xtoa(atick[j]));
puts(" ");
puts(xtoa(aspeed[j]));
puts(" ");
puts(xtoa(aduty[j]));
puts("  -->  ");
puts(xtoa(at[j]));
puts("  ");
puts(xtoa(aa[j]));
puts("  ");
if (ae[j] < 0) {
	puts("-");
	puts(xtoa(-ae[j]));
} else
	puts(xtoa(ae[j]));
puts(" ");
if (ap[j] < 0) {
	puts("-");
	puts(xtoa(-ap[j]));
} else
	puts(xtoa(ap[j]));
puts(" ");
if (ai[j] < 0) {
	puts("-");
	puts(xtoa(-ai[j]));
} else
	puts(xtoa(ai[j]));
puts(" ");
if (ad[j] < 0) {
	puts("-");
	puts(xtoa(-ad[j]));
} else
	puts(xtoa(ad[j]));
puts(" --> ");
if (ivals[j] < 0) {
	puts("-");
	puts(xtoa(-ivals[j]));
} else
	puts(xtoa(ivals[j]));
puts("\r");
}
puts("\rcurrent index: ");
puts(xtoa(iiii));
for (j = 0; j < SZ; j++) {
puts("\r");
puts(xtoa(j));
puts(" ");
puts(xtoa(amps[j]));
puts(" ");
}
puts("\rkd");
puts(xtoa(kd));
puts("\rkp");
puts(xtoa(kp));
puts("\rfinish dump\r");
}

void genSPV(int prev_tick_num, int target_tick_num) 
{
			int i, v;
			int uindex, vindex, windex;
			int time0, time1, time2;
			time0 = RT_T0_ReadCnt();
			if (hall == 0x300) {
				uindex = (tick_num*60/target_tick_num)>>4;
				if (uindex > ANGLE_NUM)
					uindex = ANGLE_NUM;
				vindex = 0;
				if (uindex <= 30)
					windex = 60 + uindex;
				else
					windex = 120 - uindex;
			} else if (hall == 0x200) {
				windex = 60 - ((tick_num*60/target_tick_num)>>4);
				if (windex < 0)
					windex = 0;
				vindex = 0;
				if (windex <= 30)
					uindex = 60 + windex;
				else
					uindex = 120 - windex;
			} else if (hall == 0x600) {
				vindex = (tick_num*60/target_tick_num)>>4;
				if (vindex > ANGLE_NUM)
					vindex = ANGLE_NUM;
				windex = 0;
				if (vindex <= 30)
					uindex = 60 + vindex;
				else
					uindex = 120 - vindex;
			} else if (hall == 0x400) {
				uindex = 60 - ((tick_num*60/target_tick_num)>>4);
				if (uindex < 0)
					uindex = 0;
				windex = 0;
				if (uindex <= 30)
					vindex = 60 + uindex;
				else
					vindex = 120 - uindex;
			} else if (hall == 0x500) {
				windex = (tick_num*60/target_tick_num)>>4;
				 if (windex > ANGLE_NUM)
					windex = ANGLE_NUM;
				uindex = 0;
				if (windex <= 30)
					vindex = 60 + windex;
				else
					vindex = 120 - windex;
			} else if (hall == 0x100) {
				vindex = 60 - ((tick_num*60/target_tick_num)>>4);
				if (vindex < 0)
					vindex = 0;
				uindex = 0;
				if (vindex <= 30)
					windex = 60 + vindex;
				else
					windex = 120 - vindex;
			} 

			
			uduty = (target_duty*sintable[uindex])>>8; // divide 256, which is the max of sintable
			vduty = (target_duty*sintable[vindex])>>8; 
			wduty = (target_duty*sintable[windex])>>8; 
			update_pwm_duty();
			time1 = RT_T0_ReadCnt();
/*
if (iii < SZ) {
id[iii] = iii;
halls[iii] = hall;		
atick[iii] = tick_num;
aspeed[iii] = actual_speed;
aduty[iii] = target_duty;
//at[iii] = uindex;
v = 0;
MemoryWrite32(SAR_CTL_REG, 0x3);
for (i = 0; i < 16; i++)
  v = v+ (MemoryRead32(0x1f800603) & 0x7ff);
at[iii] = (v >> 4);
v = 0;
MemoryWrite32(SAR_CTL_REG, 0x13);
for (i = 0; i < 16; i++)
  v = v+ (MemoryRead32(0x1f800603) & 0x7ff);
aa[iii] = (v >> 4);
//aa[iii] = uduty;
time2 = RT_T0_ReadCnt();
//ae[iii] = vindex;
ae[iii] = time1 - time0;
//ap[iii] = vduty;
ap[iii] = time2 - time1;
ai[iii] = windex;
ad[iii] = wduty;
}
iii++;
if (iii == SZ)
  iii = 0;
*/
}


int main(void)
{
	char sp;
	unsigned long speed, ctrl, sctrl;
	int target_tick_num = 0;
	int prev_tick_num = 0;
	target_speed = 0;
	target_duty = 0;
	actual_speed = 0;
	tick_num = 0;
	total_tick_num = 0;
	pwm_duty_calc_done = 0;
	iVal = 0;
	pre_err = 0;
	duty = 0;
	hall = 0;
	prev_hall = 0;
	sentype = -1;
	kp = 1;//31;
	ki = 5;
	kd = 1;//15;
	sense_step = SENSE_STEP;
	sense_thresh = 0x8;

	sys_init();
	//MemoryWrite32(0x1f800702, 0x200);

	//_Uart_sync();
	MemoryWrite32(UART_OSC_REG, 0x2);
	puts("Hello From MCU!\r\n");

	//initialize EV
	ev_init();
	//end of initialize
     	RT_T0_SetTimer(1, 0, 0); //setup tick

	puts("\rPole Number > ");
	pole_num = getnum();
	speed_times_tick = MIN_IN_USEC / pole_num;
	puts(" speed times tick number ");
	puts(xtoa(speed_times_tick));         
	print_menu();
	target_speed = getnum();
	target_err = (target_speed<<3)/100;
	//target_duty = (target_speed*MODULA)>>max_speed_shift;
	target_duty = (MODULA>>2);	
	//max_duty = target_duty;
	target_tick_num = (speed_times_tick/target_speed)>>4;
	puts("target speed ");
	puts(xtoa(target_speed));
	puts("target error ");
	puts(xtoa(target_err));
	puts(" target duty ");
	puts(xtoa(target_duty));
	puts(" target tick num ");
	puts(xtoa(target_tick_num));
	puts("\r");
	print_menu();


	RT_T0_Clr();
	prev_tick_num = 0;
	prev_hall = 0;
	total_tick_num = 0;

iii = 0;
iiii = 0;
	for (;;) {
		if (kbhit()) {
			sp = getch();
			if (sp == 's') {
				debug_dump();
			} else if (sp == '\n' || sp == '\r' || sp == ' ') {
				target_speed = speed;
				target_tick_num = (speed_times_tick/target_speed)>>4;
				speed = 0;
				iVal = 0;
				print_menu();
			} else {
				if('0' <= sp && sp <= '9')
         					sp -= '0';
      				else if('A' <= sp && sp <= 'Z')
         					sp = sp - 'A' + 10;
      				else if('a' <= sp && sp <= 'z')
         					sp = sp - 'a' + 10;
      				else if(sp == 8)  // ^H  or \b  backspace  ???
            					speed >>= 4;
              				speed = (speed << 4) + sp;
			}
		} 

		tick_num = RT_T0_ReadCnt();
		hall = RT_IO_Read16();
		hall = (hall & 0x700);
		if (hall == 0x700 || hall == 0x000)
			hall = prev_hall; //skip the error reading 
		if (prev_hall == 0) {//initial state
			prev_hall = hall;
			actual_speed = 0;
			RT_T0_Clr();
		}

		//filter out noise
		if (prev_hall != hall)  {
		if (prev_hall == 0x100) {
			if (hall != 0x300)
				continue;
		} else if (prev_hall == 0x300) {
			if (hall != 0x200)
				continue;
		} else if (prev_hall == 0x200) {
			if (hall != 0x600)
				continue;
		} else if (prev_hall == 0x600) {
			if (hall != 0x400)
				continue;
		} else if (prev_hall == 0x400) {
			if (hall != 0x500)
				continue;
		} else if (prev_hall == 0x500) {
			if (hall != 0x100)
				continue;
		} 
		}
		if (prev_hall != hall) { //correct hall event
			if (tick_num > target_tick_num) 
				actual_speed = speed_times_tick/tick_num; 
			RT_T0_Clr();
			calc_pid();
/*
			total_tick_num = total_tick_num + tick_num;
			if (hall == 0x100) {
				actual_speed = (speed_times_tick*6)/total_tick_num;
				//total_tick_num = 0;
				calc_pid();
			} 
			RT_T0_Clr();
*/
			prev_tick_num = 0;
			prev_hall = hall;
			target_tick_num = (speed_times_tick/actual_speed)>>4;
//
//if (hall == 0x100) {
if (iii < SZ) {
id[iii] = iii;
halls[iii] = hall;
atick[iii] = tick_num; //total_tick_num;
aspeed[iii] = actual_speed;
}
total_tick_num = 0;
iii++;
if (iii == SZ)
  iii = 0;
//}
//
		} /*else if (tick_num >= (target_tick_num<<8)) { //stalled, reset prev_hall and tick_num to 0 to get out of stall mode
			prev_hall = 0;
			RT_T0_Clr();
		}*/ else if ((tick_num - prev_tick_num) >= target_tick_num) {
			genSPV(prev_tick_num, target_tick_num);
			prev_tick_num = tick_num;
		} 
	}

 	return 0;
}	   
