//################################################################
// TITLE: Mini Boot Loader - m2-sejoy
// AUTHOR: John & Matt
// DATE CREATED: 12/10/2013
// FILENAME: minib.c
// PROJECT: m2-sejoy
// COPYRIGHT: Copyright (C) Camel Microelectronics, Inc.
// DESCRIPTION:
// Rev No.: V1.8
//
//   Mini Boot Loader resides @0        (2kx32 rom)
//
//  06/02/2014 - john - V1.8 - print_sysctl, clean up, and put rev, mode infor 
//  04/27/2014 - john - V1.7 - remove print_gdr in interrupt(); make it release version 
//  03/27/2014 - matt - B1.6 - T3 -> T2, max line of loader increased 
//                             to 32k lines (to fit sejoy)
//  02/26/2014 - john - B1.5 - remove explicit uart print functions
//  01/24/2014 - matt - B1.3 - more dbg msg added for loader part
//                             load file size up to 16k lines (flash size)
//  01/22/2014 - matt - B1.2 - file transfer modification 
//                           - added write loop and read loop for testing
//  12/10/2013 - john - B1.1 - based on m1 minib.c, porting to m2 sejoy
//                             use m2.h
//   
//################################################################

#include "str.h"
#include "mcu.h"
#include "TC0.h"

#define EV_PWM_CTL0_REG     0x1f800400
#define EV_PWM_CLRIRQ_REG   0x1f800403
#define EV_PWM_MODULA_REG   0x1f800404
#define EV_PWM_CONF_REG     0x1f800405
#define EV_PWM_REF5_REG     0x1f800408
#define EV_PWM_REF4_REG     0x1f800409
#define EV_PWM_REF3_REG     0x1f80040a
#define EV_PWM_REF2_REG     0x1f80040b
#define EV_PWM_REF1_REG     0x1f80040c
#define EV_PWM_REF0_REG     0x1f80040d
#define EV_PWM_DT10_REG     0x1f80040e
#define SYS_GPIO1_REG       0x1f800706
#define A_CMP_CTL_REG       0x1f800606
#define A_CLR_REG           0x1f800603
#define T0_CLRIRQ_REG     0x1f800103  

#define MODULA              0xbf
#define TICK_TIME           10 //10us
#define ANGLE_NUM           90 //angle resolution is 1 degree
#define MIN_IN_USEC         60000000

static const unsigned long sintable[91] = {
0x4, 0x8, 0xd, 0x11, 0x16, 0x1a, 0x1f, 0x23, 0x28, 0x2c, 
0x30, 0x35, 0x39, 0x3d, 0x42, 0x46, 0x4a, 0x4f, 0x53, 0x57, 
0x5b, 0x5f, 0x64, 0x68, 0x6c, 0x70, 0x74, 0x78, 0x7c, 0x7f, 
0x83, 0x87, 0x8b, 0x8f, 0x92, 0x96, 0x9a, 0x9d, 0xa1, 0xa4, 
0xa7, 0xab, 0xae, 0xb1, 0xb5, 0xb8, 0xbb, 0xbe, 0xc1, 0xc4, 
0xc6, 0xc9, 0xcc, 0xcf, 0xd1, 0xd4, 0xd6, 0xd9, 0xdb, 0xdd, 
0xdf, 0xe2, 0xe4, 0xe6, 0xe8, 0xe9, 0xeb, 0xed, 0xee, 0xf0, 
0xf2, 0xf3, 0xf4, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 
0xfc, 0xfd, 0xfe, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff 
};
static const unsigned long max_speed_shift = 10; //correspond to 1024
static unsigned long target_speed;
static unsigned long target_duty;
static unsigned long actual_speed;
static int tick_num;
static int pwm_duty_calc_done;
static unsigned long iVal;
static unsigned long pre_err;
static unsigned long duty;
static unsigned long max_duty;
static unsigned long hall;
static int pole_num;
static unsigned long speed_times_tick;
static int extflag;

typedef void (*FuncPtr)(void);
void update_pwm_duty();


void user_interrupt()
{
	FuncPtr funcptr;
	int index;
	unsigned long irq = MemoryRead32(SYS_IRQ_REG);
	puts("interrupt ");
	puts(xtoa(irq));
	puts("\r");
	if (irq & 0x200) //bit 9, analog interrupt, comparator interrupt
	{
int hall1;
		//hall value changed, calculate speed
		hall = MemoryRead32(A_CLR_REG);
hall1 = MemoryRead32(0x1f800706);
		hall = (hall & 0x7000);
		tick_num = RT_T0_ReadCnt();
		if (tick_num > 0) 
			actual_speed = speed_times_tick/tick_num; 
		MemoryWrite32(T0_READ_REG, 0);
		MemoryWrite32(0x1f800603, 0);

		//puts("hall value changed ");
		puts(xtoa(hall));
/*puts(" ");
puts(xtoa(hall1));
		puts(" actual_speed = ");
		puts(xtoa(actual_speed));
		puts(" irq = ");
		puts(xtoa(irq));*/
		puts("\r");
	} else if (irq & 0x20) { //ext interrupt		
		MemoryWrite32(0x1f800503, 0);
		MemoryWrite32(0x1f800502, extflag);
		extflag = ((~extflag)&1);
		//hall value changed, calculate speed
		hall = MemoryRead32(A_CLR_REG);
		hall = (hall & 0x7000);
		tick_num = RT_T0_ReadCnt();
		if (tick_num > 0) 
			actual_speed = speed_times_tick/tick_num; 
		MemoryWrite32(T0_READ_REG, 0);

		puts("hall value changed ");
		puts(xtoa(hall));
		puts(" actual_speed = ");
		puts(xtoa(actual_speed));
		puts(" irq = ");
		puts(xtoa(irq));
		puts("\r");

	}
}

void set_ev_pwm_ref(unsigned long ref5, unsigned long ref4, unsigned long ref3, unsigned long ref2, unsigned long ref1, unsigned long ref0)
{
	MemoryWrite32(EV_PWM_REF5_REG, ref5);
	MemoryWrite32(EV_PWM_REF4_REG, ref4);
	MemoryWrite32(EV_PWM_REF3_REG, ref3);
	MemoryWrite32(EV_PWM_REF2_REG, ref2);
	MemoryWrite32(EV_PWM_REF1_REG, ref1);
	MemoryWrite32(EV_PWM_REF0_REG, ref0);
}

void print_menu()
{
	puts("\r\nenter speed > ");
}

void update_pwm_duty()
{
	if (hall == 0x4000) 
		set_ev_pwm_ref(0xc0, duty, 0xc0, 0x00, 0x00, 0x00); 
	else if (hall == 0x5000) 
		set_ev_pwm_ref(0xc0, 0x00, 0xc0, duty, 0x00, 0x00);
	else if (hall == 0x1000) 
		set_ev_pwm_ref(0x00, 0x00, 0xc0, duty, 0xc0,
0x00);
	else if (hall == 0x3000) 
		set_ev_pwm_ref(0x00, 0x00, 0xc0, 0x00, 0xc0, duty);
	else if (hall == 0x2000)
		set_ev_pwm_ref(0xc0, 0x00, 0x00, 0x00, 0xc0, duty);
	else if (hall == 0x6000)
		set_ev_pwm_ref(0xc0, duty, 0x00, 0x00, 0xc0, 0x00);
}

void ev_init()
{
	MemoryWrite32(EV_PWM_CLRIRQ_REG, 0);  //reset all EV_PWM_REFx_REG to 0
	MemoryWrite32(EV_PWM_CTL0_REG, 0x121); //every two period change EV_PWM_REFx_REG
	MemoryWrite32(EV_PWM_MODULA_REG, MODULA); //set PWM period
	MemoryWrite32(EV_PWM_CONF_REG, 0x700);  //edge align mode, each PWM is independent
	MemoryWrite32(EV_PWM_DT10_REG, 0x101); //set deadtime to 1 on each side
	MemoryWrite32(SYS_CTL0_REG, 0x9); //use GPIO to read hall a,b,c, need to do uart_sync to set the correct uart osc freq since the external pin setting no longer work when GPIO is used
	MemoryWrite32(A_CMP_CTL_REG, 0x8007); //use all the comparators and enable interrupt request
	MemoryWrite32(T0_CTL0_REG, 0);
	//MemoryWrite32(0x1f800500, 1);
	//MemoryWrite32(0x1f800502, 1);
	//MemoryWrite32(0x1f800503, 0);
	extflag = 0;
}

void calc_pid()
{
	unsigned long error, P_term, I_term, D_term;
	unsigned long iMax = 100000000;
	unsigned long iMin = 0;
	int kp = 255;
	int ki = 255;
	int kd = 1;
	int shift_num = 12;
	error = target_speed - actual_speed;
	P_term = (kp * error)>>shift_num;
	iVal += error;
	if (iVal > iMax)
		iVal = iMax;
	else if (iVal < iMin)
		iVal = iMin;
	I_term = (ki * iVal)>>shift_num;
	D_term = (kd *(pre_err - error))>>shift_num;
	pre_err = error;
	max_duty = target_duty - (P_term + I_term + D_term);
	/*puts(" error = ");
	puts(xtoa(error));
	puts(" P_term = ");
	puts(xtoa(P_term));
	puts(" I_term = ");
	puts(xtoa(I_term));
	puts(" D_term = ");
	puts(xtoa(D_term));
	puts(" max_duty = ");
	puts(xtoa(max_duty));
	puts("\r");*/
}

int main(void)
{
	char sp;
	unsigned long speed, ctrl, sctrl;
	int target_tick_num = 0;
	int prev_tick_num = 0;
	target_speed = 0;
	target_duty = 0;
	actual_speed = 0;
	tick_num = 0;
	pwm_duty_calc_done = 0;
	iVal = 0;
	pre_err = 0;
	duty = 0;
	max_duty = 0;
	hall = 0;

	sys_init();
	

	//_Uart_sync();
	MemoryWrite32(UART_OSC_REG, 0x2);
	puts("Hello From MCU!\r\n");

	puts("\rPole Number > ");
	pole_num = getnum();
	speed_times_tick = MIN_IN_USEC  /2 / pole_num;
	puts(" speed times tick number ");
	puts(xtoa(speed_times_tick));         
	print_menu();
	target_speed = getnum();
	target_duty = (target_speed*MODULA)>>max_speed_shift;	
	target_tick_num = (speed_times_tick/target_speed)>>4;
	puts("target speed ");
	puts(xtoa(target_speed));
	puts(" target duty ");
	puts(xtoa(target_duty));
	puts(" target tick num ");
	puts(xtoa(target_tick_num));
	puts("\r");


	//initialize EV
	ev_init();
	//end of initialize
     	RT_T0_SetTimer(1, 0, 0); //setup tick
	MemoryWrite32(T0_READ_REG, 0);
	prev_tick_num = 0;

	for (;;) {
		tick_num = RT_T0_ReadCnt();
		/*puts("tick_num ");
		puts(xtoa(tick_num));
		puts("\r");*/

		if (kbhit()) {
			sp = getch();
			if (sp == '\n' || sp == '\r' || sp == ' ') {
				target_speed = speed;
				target_duty = (target_speed*MODULA)>>max_speed_shift;
				target_tick_num = (speed_times_tick/target_speed)>>4;
				speed = 0;
				print_menu();
			} else {
				if('0' <= sp && sp <= '9')
         					sp -= '0';
      				else if('A' <= sp && sp <= 'Z')
         					sp = sp - 'A' + 10;
      				else if('a' <= sp && sp <= 'z')
         					sp = sp - 'a' + 10;
      				else if(sp == 8)  // ^H  or \b  backspace  ???
            					speed >>= 4;
              				speed = (speed << 4) + sp;
			}
		}
		if ((tick_num - prev_tick_num) == target_tick_num) {
			int index;
int hall1, hall2, cmp, irq1, cmpout;
			int time0, time1, time2;
			time0 = RT_T0_ReadCnt();
			calc_pid();
			time1 = RT_T0_ReadCnt();
			if ((hall == 0x3000) || (hall == 0x6000) || (hall == 0x5000))
				index = tick_num*target_speed*ANGLE_NUM/speed_times_tick;
			else
				index = ANGLE_NUM - tick_num*target_speed*ANGLE_NUM/speed_times_tick;
			time2 = RT_T0_ReadCnt();
			if (index < 0)
				index = 0;
			else if (index > ANGLE_NUM)
				index = ANGLE_NUM;
			duty = target_duty*sintable[index]>>8; // divide 256, which is the max of sintable
			update_pwm_duty();
			//prev_tick_num = tick_num;
			tick_num = RT_T0_ReadCnt();
hall = MemoryRead32(A_CLR_REG);
hall1 = MemoryRead32(0x1f800704);
/*hall2 = MemoryRead32(A_CMP_CTL_REG);
cmp = MemoryRead32(0x1f80060a);
irq1 = MemoryRead32(SYS_IRQ_REG);
sctrl = MemoryRead32(SYS_CTL0_REG);
cmpout = MemoryRead32(0x1f800603);*/
			puts(xtoa(hall));
puts(" ");
			puts(xtoa(hall1));
/*puts(" ");
puts(xtoa(hall2));
puts(" ");
puts(xtoa(cmp));
puts(" ");
puts(xtoa(irq1));
puts(" ");
puts(xtoa(sctrl));
puts(" ");
puts(xtoa(cmpout));*/
			/*puts(" ");
			puts("start ");
			puts(xtoa(time0));
			puts(" end ");
			puts(xtoa(tick_num));
			puts( " used ");
			index = tick_num - time0;
			puts(xtoa(index));
			index = time1 - time0;
			puts(" ");
			puts(xtoa(index));
			index = time2 - time1;
			puts(" ");
			puts(xtoa(index));
			index = tick_num - time2;
			puts(" ");
			puts(xtoa(index));*/
			puts("\r");
			prev_tick_num = tick_num;
		}
	}

 	return 0;
}	   
