//################################################################
// TITLE: Mini Boot Loader - m2-sejoy
// AUTHOR: John & Matt
// DATE CREATED: 12/10/2013
// FILENAME: minib.c
// PROJECT: m2-sejoy
// COPYRIGHT: Copyright (C) Camel Microelectronics, Inc.
// DESCRIPTION:
// Rev No.: V1.8
//
//   Mini Boot Loader resides @0        (2kx32 rom)
//
//  06/02/2014 - john - V1.8 - print_sysctl, clean up, and put rev, mode infor 
//  04/27/2014 - john - V1.7 - remove print_gdr in interrupt(); make it release version 
//  03/27/2014 - matt - B1.6 - T3 -> T2, max line of loader increased 
//                             to 32k lines (to fit sejoy)
//  02/26/2014 - john - B1.5 - remove explicit uart print functions
//  01/24/2014 - matt - B1.3 - more dbg msg added for loader part
//                             load file size up to 16k lines (flash size)
//  01/22/2014 - matt - B1.2 - file transfer modification 
//                           - added write loop and read loop for testing
//  12/10/2013 - john - B1.1 - based on m1 minib.c, porting to m2 sejoy
//                             use m2.h
//   
//################################################################

#include "str.h"
#include "mcu.h"
#include "MCUIO.h"
#include "sar.h"
#include "TC0.h"


#define EV_PWM_CTL0_REG     0x1f800400
#define EV_PWM_CLRIRQ_REG   0x1f800403
#define EV_PWM_MODULA_REG   0x1f800404
#define EV_PWM_CONF_REG     0x1f800405
#define EV_PWM_REF0_REG     0x1f800408
#define EV_PWM_REF1_REG     0x1f800409
#define EV_PWM_REF2_REG     0x1f80040a
#define EV_PWM_REF3_REG     0x1f80040b
#define EV_PWM_REF4_REG     0x1f80040c
#define EV_PWM_REF5_REG     0x1f80040d
#define EV_PWM_DT10_REG     0x1f80040e
#define SYS_GPIO1_REG       0x1f800706
#define A_CMP_CTL_REG   	0x1f800606
#define A_CLR_REG		0x1f800603


void user_interrupt()
{

}

void set_ev_pwm_ref(unsigned long ref0, unsigned long ref1, unsigned long ref2, unsigned long ref3, unsigned long ref4, unsigned long ref5)
{
	MemoryWrite32(EV_PWM_REF5_REG, ref5);
	MemoryWrite32(EV_PWM_REF4_REG, ref4);
	MemoryWrite32(EV_PWM_REF3_REG, ref3);
	MemoryWrite32(EV_PWM_REF2_REG, ref2);
	MemoryWrite32(EV_PWM_REF1_REG, ref1);
	MemoryWrite32(EV_PWM_REF0_REG, ref0);
}

void print_menu()
{
	puts("\r\nenter speed > ");
}

void ev_init()
{
	//initialize EV
	MemoryWrite32(EV_PWM_CLRIRQ_REG, 0);  //reset all EV_PWM_REFx_REG to 0
	MemoryWrite32(EV_PWM_CTL0_REG, 0x121); //every two period change EV_PWM_REFx_REG
	MemoryWrite32(EV_PWM_MODULA_REG, 0xbf); //set PWM period
	MemoryWrite32(EV_PWM_CONF_REG, 0x700);  //edge align mode, each PWM is independent
	MemoryWrite32(EV_PWM_DT10_REG, 0x101); //set deadtime to 1 on each side
	//MemoryWrite32(SYS_CTL0_REG, 0x8); //use GPIO to read hall a,b,c, need to do uart_sync to set the correct uart osc freq since the external pin setting no longer work when GPIO is used
	//MemoryWrite32(A_CMP_CTL_REG, 0x37); //use all the comparators, vref is set to 1.5v
	RT_IOCTL_Set16(0);
	//end of initialize
}

int main(void)
{
register unsigned long time, time0, dt; //time1, dt, dt1;
register int count;
	register unsigned long hall;
	register unsigned long prev_hall, ph, tmp;
	unsigned long speed;
	unsigned long duty;
	register unsigned long bema, bemb, bemc, bemin, bemax, bemavg;
	char sp;
	sys_init();	
	ev_init();
	MemoryWrite32(UART_OSC_REG, 0x2);
	//MemoryWrite32(0x1f800702, 0x200); //12Mhz
	
	puts("Hello From MCU!\r\n");

	print_menu();
	speed = getnum();
	duty = speed;
	speed = 0;		
	puts(xtoa(duty));
	print_menu();
	
	prev_hall = 0;
	ph = 0;
time0 = 0;
count = 0;
	for (;;) {
count++;
		if (kbhit()) {
			sp = getch();
			if (sp == '\n' || sp == '\r' || sp == ' ') {
				duty = speed;
				speed = 0;
				puts(xtoa(duty));
				print_menu();
			} else {
				if('0' <= sp && sp <= '9')
         					sp -= '0';
      				else if('A' <= sp && sp <= 'Z')
         					sp = sp - 'A' + 10;
      				else if('a' <= sp && sp <= 'z')
         					sp = sp - 'a' + 10;
      				else if(sp == 8)  // ^H  or \b  backspace  ???
            					speed >>= 4;
              				speed = (speed << 4) + sp;
			}
		}
/*
time = RT_T0_ReadCnt();
if (time0 != 0 && time > time0)
	dt = time - time0;
else 
	dt = 0;
time0 = time;*/
//time1 = RT_T0_ReadCnt();
bema = measure0(1, 0);
bemb = measure0(1, 1);
bemc = measure0(1, 2);
/*time = RT_T0_ReadCnt();
if (time > time1)
	dt1 = time - time1;
else
	dt1 = 0;*/
bemin = bema;
bemax = bema;
if (bemb > bemax)
	bemax = bemb;
else if (bemb < bemin)
	bemin = bemb;
if (bemc > bemax)
	bemax = bemc;
else if (bemc < bemin)
	bemin = bemc;
bemavg = (15*bemax + 17*bemin)>>5;
hall = 0;
if (bema > bemavg)
	hall |= (1<<8);
if (bemb > bemavg)
	hall |= (1<<9);
if (bemc > bemavg)
	hall |= (1<<10);
//CMProbe(2,bema);
//CMProbe(3,bemb);
//CMProbe(4,bemc);
//CMProbe(5, h0);

//if (dt > 0)
//	CMProbe(6,dt);

//if (dt1 > 0)
//	CMProbe(7, dt1);
		if (hall != prev_hall) {
			if (hall == 0x400) {
				set_ev_pwm_ref(0x00, duty, 0x00, 0x00, 0xc0, 0x00); 
			} else if (hall == 0x500) {
				set_ev_pwm_ref(0x00, 0x00, 0x00, duty, 0xc0, 0x00);
			} else if (hall == 0x100) {
				set_ev_pwm_ref(0xc0, 0x00, 0x00, duty, 0x00, 0x00);
			} else if (hall == 0x300) {
				set_ev_pwm_ref(0xc0, 0x00, 0x00, 0x00, 0x00, duty);
			} else if (hall == 0x200) {
				set_ev_pwm_ref(0x00, 0x00, 0xc0, 0x00, 0x00, duty);
			} else if (hall == 0x600) {
				set_ev_pwm_ref(0x00, duty, 0xc0, 0x00, 0x00, 0x00);
			}
			prev_hall = hall;
			if (count > 1000) {
				time = RT_T0_ReadCnt();
				dt = (time - time0)/count;
				//CMProbe(1,dt);
				count = 0;
				time0 = time;
			}
		}
	}

 	return 0;
}	   
