#include "sar.h"
#include "mcu.h"

#define RMSZ 4
#define SIZE 6
#define MAX 0x1fffffff
#define MIN 0

int measure0(int size0, int channel)
{
	register int i, j, size;
	register int v0;
	register int minv, maxv, sum;
	MemoryWrite32(SAR_CTL_REG, (channel<<4)|1); 
	if (size0 > SIZE)
		size0 = SIZE;
	size = (1<<size0)+2;
	minv = MAX;
	maxv = MIN;
	sum = 0;
	for (i = 0; i < size; i++) {
		
		j = 0; 
		while (j < 2)
			j++;

  		v0 = (MemoryRead32(0x1f800603) & 0x7ff);
		if (v0 < minv) 
			minv = v0;
		if (v0 > maxv) 
			maxv = v0;
		sum += v0;
	}
	sum -= (minv+maxv);
	return sum>>size0;
}


