//################################################################
// TITLE: Mini Boot Loader - m2-sejoy
// AUTHOR: John & Matt
// DATE CREATED: 12/10/2013
// FILENAME: minib.c
// PROJECT: m2-sejoy
// COPYRIGHT: Copyright (C) Camel Microelectronics, Inc.
// DESCRIPTION:
// Rev No.: V1.8
//
//   Mini Boot Loader resides @0        (2kx32 rom)
//
//  06/02/2014 - john - V1.8 - print_sysctl, clean up, and put rev, mode infor 
//  04/27/2014 - john - V1.7 - remove print_gdr in interrupt(); make it release version 
//  03/27/2014 - matt - B1.6 - T3 -> T2, max line of loader increased 
//                             to 32k lines (to fit sejoy)
//  02/26/2014 - john - B1.5 - remove explicit uart print functions
//  01/24/2014 - matt - B1.3 - more dbg msg added for loader part
//                             load file size up to 16k lines (flash size)
//  01/22/2014 - matt - B1.2 - file transfer modification 
//                           - added write loop and read loop for testing
//  12/10/2013 - john - B1.1 - based on m1 minib.c, porting to m2 sejoy
//                             use m2.h
//   
//################################################################

#include "str.h"
#include "mcu.h"


#define EV_PWM_CTL0_REG     0x1f800400
#define EV_PWM_CLRIRQ_REG   0x1f800403
#define EV_PWM_MODULA_REG   0x1f800404
#define EV_PWM_CONF_REG     0x1f800405
#define EV_PWM_REF0_REG     0x1f800408
#define EV_PWM_REF1_REG     0x1f800409
#define EV_PWM_REF2_REG     0x1f80040a
#define EV_PWM_REF3_REG     0x1f80040b
#define EV_PWM_REF4_REG     0x1f80040c
#define EV_PWM_REF5_REG     0x1f80040d
#define EV_PWM_DT10_REG     0x1f80040e
#define SYS_GPIO1_REG       0x1f800706


void user_interrupt()
{

}

void set_ev_pwm_ref(unsigned long ref0, unsigned long ref1, unsigned long ref2, unsigned long ref3, unsigned long ref4, unsigned long ref5)
{
	MemoryWrite32(EV_PWM_REF5_REG, ref5);
	MemoryWrite32(EV_PWM_REF4_REG, ref4);
	MemoryWrite32(EV_PWM_REF3_REG, ref3);
	MemoryWrite32(EV_PWM_REF2_REG, ref2);
	MemoryWrite32(EV_PWM_REF1_REG, ref1);
	MemoryWrite32(EV_PWM_REF0_REG, ref0);
/*puts("\rset pwm ");
puts(xtoa(ref5));
puts(" ");
puts(xtoa(ref4));
puts(" ");
puts(xtoa(ref3));
puts(" ");
puts(xtoa(ref2));
puts(" ");
puts(xtoa(ref1));
puts(" ");
puts(xtoa(ref0));*/
}

void print_menu()
{
	puts("\r\nenter speed > ");
}

unsigned long getspeed()
{
	char sp;
	unsigned long speed;
	sp = getch();
	switch(sp) {
		case '1' :
			speed = 0xbf;
			break;
		case '2' :
			speed = 0xaf;
			break;
		case '3' :
			speed = 0x9f;
			break;
		case '4' :
			speed = 0x8f;
			break;
		case '5' :
			speed = 0x7f;
			break;
		case '6' :
			speed = 0x6f;
			break;
		case '7' :
			speed = 0x5f;
			break;
		case '8' :
			speed = 0x4f;
			break;
		case '9' :
			speed = 0x3f;
			break;
		default:
			speed = 0x2f;
			break;
	}
	return speed;
}


int main(void)
{
	unsigned long hall;
	unsigned long prev_hall;
	unsigned long speed;
	unsigned long duty;
	char sp;
	sys_init();
	
	//initialize EV
	MemoryWrite32(EV_PWM_CLRIRQ_REG, 0);  //reset all EV_PWM_REFx_REG to 0
	MemoryWrite32(EV_PWM_CTL0_REG, 0x121); //every two period change EV_PWM_REFx_REG
	MemoryWrite32(EV_PWM_MODULA_REG, 0xbf); //set PWM period
	MemoryWrite32(EV_PWM_CONF_REG, 0x700);  //edge align mode, each PWM is independent
	MemoryWrite32(EV_PWM_DT10_REG, 0x101); //set deadtime to 1 on each side
	MemoryWrite32(SYS_CTL0_REG, 0x8); //use GPIO to read hall a,b,c, need to do uart_sync to set the correct uart osc freq since the external pin setting no longer work when GPIO is used
	RT_IO_Set16(0);
	//end of initialize

	//_Uart_sync();
	MemoryWrite32(UART_OSC_REG, 0x2);
	puts("Hello From MCU!\r\n");

	print_menu();
	//speed = getspeed();
	speed = getnum();
	duty = speed;		
	//MemoryWrite32(EV_PWM_MODULA_REG, speed);
	//speed = 0;
	//speed = MemoryRead32(EV_PWM_MODULA_REG);
	puts("pwm modula = ");
	puts(xtoa(speed));
	puts("\r\n");
	
	prev_hall = 0;
	for (;;) {
		if (kbhit()) {
			//speed = getspeed();
			//print_menu();
			sp = getch();
			if (sp == '\n' || sp == '\r' || sp == ' ') {
				//MemoryWrite32(EV_PWM_MODULA_REG, speed);
				duty = speed;
				speed = 0;
puts("\rspeed = ");
puts(xtoa(duty));
			} else {
				if('0' <= sp && sp <= '9')
         				sp -= '0';
      			else if('A' <= sp && sp <= 'Z')
         				sp = sp - 'A' + 10;
      			else if('a' <= sp && sp <= 'z')
         				sp = sp - 'a' + 10;
      			else if(sp == 8)  // ^H  or \b  backspace  ???
            			speed >>= 4;
              		speed = (speed << 4) + sp;
			}
			//speed = MemoryRead32(EV_PWM_MODULA_REG);
			//puts("pwm modula = ");
			//puts(xtoa(speed));
			//puts("\r\n");
		}
		hall = RT_IO_Read16();
		hall = (hall & 0x700);
		if (hall != prev_hall) {
//puts("\rhall = ");
//puts(xtoa(hall));
//400, 500, 100, 300, 200, 600
/* original
			if (hall == 0x400) 
				set_ev_pwm_ref(0xc0, duty, 0xc0, 0x00, 0x00, 0x00); 
			else if (hall == 0x500) 
				set_ev_pwm_ref(0xc0, 0x00, 0xc0, duty, 0x00, 0x00);
			else if (hall == 0x100) 
				set_ev_pwm_ref(0x00, 0x00, 0xc0, duty, 0xc0, 0x00);
			else if (hall == 0x300) 
				set_ev_pwm_ref(0x00, 0x00, 0xc0, 0x00, 0xc0, duty);
			else if (hall == 0x200)
				set_ev_pwm_ref(0xc0, 0x00, 0x00, 0x00, 0xc0, duty);
			else if (hall == 0x600)
				set_ev_pwm_ref(0xc0, duty, 0x00, 0x00, 0xc0, 0x00);
*/
			if (hall == 0x400) {
				set_ev_pwm_ref(0x00, duty, 0x00, 0x00, 0xc0, 0x00); 
				//putc_uart('4');
			} else if (hall == 0x500) {
				set_ev_pwm_ref(0x00, 0x00, 0x00, duty, 0xc0, 0x00);
				//putc_uart('5');
			} else if (hall == 0x100) {
				set_ev_pwm_ref(0xc0, 0x00, 0x00, duty, 0x00, 0x00);
				//putc_uart('1');
			} else if (hall == 0x300) {
				set_ev_pwm_ref(0xc0, 0x00, 0x00, 0x00, 0x00, duty);
				//putc_uart('3');
			} else if (hall == 0x200) {
				set_ev_pwm_ref(0x00, 0x00, 0xc0, 0x00, 0x00, duty);
				//putc_uart('2');
			} else if (hall == 0x600) {
				set_ev_pwm_ref(0x00, duty, 0xc0, 0x00, 0x00, 0x00);
				//putc_uart('6');
			}
			prev_hall = hall;
		}
	}

 	return 0;
}	   
