/*--------------------------------------------------------------------
 * TITLE: GPIO Defines
 * AUTHOR: Weize 
 * DATE CREATED: 2020/1/25
 * FILENAME: GPIO.h
 * PROJECT: w2
 * COPYRIGHT: Camel Microelectronics, Inc.
 * DESCRIPTION:
 *    w2 Hardware Defines
 *
 *    2020-01-25: initial
 *--------------------------------------------------------------------*/
#ifndef __GPIO_H__
#define __GPIO_H__
#include "MCU.h"


/*************** IO Setup***************/
#define RT_GPIO_EnWriteBit(n, oe) 	MCU_REG_WRITE(MCU_GPIO_RW, 1<<n, n, oe)
#define RT_GPIO_EnWrite(oe)		MCU_GPIO_RW = oe
#define RT_GPIO_WriteBit(n, v)	MCU_REG_WRITE(MCU_GPIO_WRITE, 1<<n, n, v)
#define RT_GPIO_Write(v)		MCU_GPIO_WRITE = v
#define RT_GPIO_ReadBit(n)		MCU_REG_READ(MCU_GPIO_READ, 1<<n, n)
#define RT_GPIO_Read()		MCU_GPIO_READ
#define RT_GPIO_ReadWriteBit(n)         MCU_REG_READ(MCU_GPIO_WRITE, 1<<n, n)
#define RT_GPIO_ReadWrite()		MCU_GPIO_WRITE
/**************** IO End****************/
#define SET_GPIO_BIT_ON(A)             {RT_GPIO_EnWriteBit(A, 1); RT_GPIO_WriteBit(A, 1);}
#define SET_GPIO_BIT_OFF(A)            {RT_GPIO_EnWriteBit(A, 1); RT_GPIO_WriteBit(A, 0); }
#endif //__GPIO_H__








































