/*--------------------------------------------------------------------
 * TITLE: WAKE up module Defines
 * AUTHOR: Weize 
 * DATE CREATED: 2020/11/15
 * FILENAME: WAK.h
 * PROJECT: w2
 * COPYRIGHT: Camel Microelectronics, Inc.
 * DESCRIPTION:
 *    w2 Hardware Defines
 *
 *    2020-11-15: initial
 *--------------------------------------------------------------------*/
#ifndef __WAK_H__
#define __WAK_H__

#define WAKE_CLK_1_32 0x00   //clock unit is 1/32s
#define WAKE_CLK_1_8  0x01   //clock unit is 1/8s
#define WAKE_CLK_1_2  0x02   //clock unit is 1/2s
#define WAKE_CLK_2    0x03   //clock unit is 2s

/*********** Hardware addesses ***********/
#define WAK_CTRL_EN_Pos                19U        //bit to enable WDT 
#define WAK_CTRL_EN_Msk                (1U<<WAK_CTRL_EN_Pos)
#define WAK_CTRL_CLK_Pos               16U        //start location for WAKE timer clk div
#define WAK_CTRL_CLK_Msk               (3U<<WAK_CTRL_CLK_Pos)
#define WAK_CTRL_TIME_Pos            	0U        //value of wake time
#define WAK_CTRL_TIME_Msk            (0xFFFFU<<WAK_CTRL_TIME_Pos)

/*************** WAKE Setup***************/
//********************************************************//
// void RT_WAKE_SetTime(time, clksel);          			      //
//                                                        //
// Description:                                           //
// This function setup the time for wakeup    				      //
// time:   wake up time, in unit of set by clksel                    //
// clksel: base clock unit, one of WAKE_CLK_1_32, WAKE_CLK_1_8
//		WAKE_CLK_1_2 or WAKE_CLK_2						          //						          //
//********************************************************//
#define RT_WAKE_SetTime(time, clksel)        MCU_WAK_CLR = 1; \
MCU_WAK_CTRL = ((1<<WAK_CTRL_EN_Pos)|(clksel<<WAK_CTRL_CLK_Pos)|(time<<WAK_CTRL_TIME_Pos))
#define RT_WAKE_Start_DeepSleep()	MCU_REG_WRITE(MCU_CTRL, CTRL_GPIO_EN_Msk, CTRL_GPIO_EN_Pos, 1); \
MCU_REG_WRITE(MCU_CTRL, CTRL_SLEEP1_EN_Msk, CTRL_SLEEP1_EN_Pos, 1)

/**************** WAK End****************/

#endif //__WAK_H__
























