//########################################################//
//  Title:Sub-function for SD	      //	 
//  AUTHER:lilb                                           //
//  PROJECT:c2d                                            //
//########################################################//


#include "SD.h"

void RT_SD_Init(int sd_filter_size, int sd_filter_order)
{ 
	SD_FILTER_SIZE = sd_filter_size;
	SD_FILTER_ORDER = sd_filter_order;
	SD_AVG=0;
	SD_SUM=0;
}

int RT_SD_Read()
{
	//use 2^SD_FILTER_ORDER for the filter average count
	register int read;
	register int sum;
	register int i, j;
	register int cap;
	cap = (1<<SD_FILTER_SIZE);
	read = 0;
	for (i = 0; i < cap; i++) {
		read += ((MemoryRead32(0x1f800603)&0x7FFFFFFF)>>8);
		for (j = 0; j < 64; j++) { } /*waiting 64 cycle for next read*/
	}
	read = (read>>SD_FILTER_SIZE);
	if (SD_AVG == 0) {
		SD_AVG = read;
	}
	SD_SUM += (read - SD_AVG);
	sum = (SD_SUM>>SD_FILTER_ORDER);
	SD_AVG += sum;
	SD_SUM -= (sum<<SD_FILTER_ORDER);
	SD_SUM = (((SD_SUM<<SD_FILTER_ORDER)-SD_SUM)>>SD_FILTER_ORDER);
	return SD_AVG;
}
