#include "INT_CLK.h"
#include "MCU.h"


void Calibrate_Internal_Clock(uint32_t freq)  
{
    volatile register uint32_t addr, data, i;
    uint32_t __sys_regs[] = {0x1f800700, 0x1f800701, 0x1f800702, MCU_UART0_BASE+MCU_UART_CTRL_Pos, MCU_UART0_BASE+MCU_UART_BRP_Pos, 
                               MCU_UART1_BASE+MCU_UART_CTRL_Pos, MCU_UART1_BASE+MCU_UART_BRP_Pos};
    data = MemoryRead(0x10200268); //MCU internal oscillator freq in kHz
    __XTAL_FREQ = data;  //in khz
    if (freq > 0) { //only change the MCU freq if freq is larger than 0
        i = 0;
        for (addr = 0x10200038; addr <= 0x10200050; addr = addr +4) {
            data = MemoryRead(addr);
            if (data == 0xFFFFFFFF) {
                data = MemoryRead(addr + 0x200);
            }
            if (data != 0xFFFFFFFF) {                
                if (i == 2) { //fix MCU clock freq to 32Mhz, 16Mhz and  8Mhz
                    if (freq > 16) {
                        data = 0x2000;
                    } else if (freq > 8) {
                        data = 0x1000;
                    } else {
                        data = 0x0;
                    }
                }
                MemoryWrite(__sys_regs[i], data);
            }
            i = i +1;
        }
    }
}

void Calibrate_Internal_Clock_Debug(uint32_t freq)  
{
	__XTAL_FREQ = 0x1B70;
	MemoryWrite32(0x1f800700, 0x100);
	MemoryWrite32(0x1f800701, 0xD00);
	if (freq > 16) {
		MemoryWrite32(0x1f800702, 0x2000);
	} else if (freq > 8) {
		MemoryWrite32(0x1f800702, 0x1000);
	} else {
		MemoryWrite32(0x1f800702, 0x0);
	}
	MemoryWrite32(0x1f800007, 0x66E);
}























